﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    //Nota:la secuencia de xml que se envian son:  POSBCStatus,POSReceiptEvent,POSTotalEvents,AddItemResponse
    /// Respuesta a petición del primer mensaje de agregar item - (AddItem) - Cabecera
    /// </summary>
    public class POSReceiptEventHeaderResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public POSReceiptEventHeaderResponse(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
               get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSReceiptEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema"
                                                UpdateType="Add">
                          <RequestID>{RequestID}</RequestID>
                          <Type>Customer</Type>
                          <Index>0</Index>
                          <Section>Header</Section>
                          <Group>{RequestID}</Group>
                          <FormattedReceiptLineList>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Header</LineCategory>
                              <LineType>StoreHeader</LineType>
                              <TextReceiptLine>
                                <Text>***************************************</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Header</LineCategory>
                              <LineType>StoreHeader</LineType>
                              <TextReceiptLine>
                                <Text>              TIENDAS ISIMO</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                            <FormattedReceiptLine>
                              <Feeds>1</Feeds>
                              <Align>center</Align>
                              <LineCategory>Header</LineCategory>
                              <LineType>StoreHeader</LineType>
                              <TextReceiptLine>
                                <Text>***************************************</Text>
                              </TextReceiptLine>
                            </FormattedReceiptLine>
                          </FormattedReceiptLineList>
                        </schema:POSReceiptEvent>
                        """;
        }
    }
}
