﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.Printer
{
    /// <summary>
    /// Evento que se envia cuando chec manda el request de la impresora
    /// </summary>
    public class POSBCStatusEventPrinter : Respuesta
    {
        public string Severity { get; set; }
        public string Status { get; set; }
        public string StatusMessage { get; set; }
        public int JobIndex { get; set; }
        public int JobTotal { get; set; }
        private string _xml;
        
        public POSBCStatusEventPrinter(int sessionId,
                                            TipoMensaje messageType,
                                            string severity,
                                            string status,
                                            string statusMessage,
                                            int jobIndex,
                                            int jobTotal) : base(sessionId, messageType)
        {
            Severity = severity;
            Status = status;
            StatusMessage = statusMessage;
            JobIndex = jobIndex;
            JobTotal = jobTotal;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:POSBCStatusEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema"> 
                          <PrinterStatus> 
                            <Severity>{Severity}</Severity>
                            <Status>{Status}</Status>
                               <StatusMessage>
                                 {StatusMessage}
                               </StatusMessage>
                            <JobIndex>{JobIndex}</JobIndex>
                            <JobTotal>{JobTotal}</JobTotal>
                          </PrinterStatus>
                        </schema:POSBCStatusEvent>
                        """;

        }

    }
}
