﻿using EvaPOS_API_FRAME.Comandos;
using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta de la impresora cuando se termina la transaccion
    /// </summary>
    public class PrintCurrentReceiptsResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public PrintCurrentReceiptsResponse(int sessionId,
                                            TipoMensaje messageType,
                                            int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:PrintCurrentReceiptsResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <PrintCurrentReceiptsResult>
                            <RequestID>{RequestID}</RequestID>
                          </PrintCurrentReceiptsResult>
                        </schema:PrintCurrentReceiptsResponse>
                        """;
        }
    }
}
