﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de agregar item - (AddReceiptLinesResponse)
    /// </summary>
    public class AddReceiptLinesResponse : Respuesta
    {
        public int RequestID { get; set; }
        private string _xml;

        public AddReceiptLinesResponse(int sessionId,
                                       TipoMensaje messageType,
                                       int requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:AddReceiptLinesResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <AddReceiptLinesResult>
                            <RequestID>{RequestID}</RequestID>
                          </AddReceiptLinesResult>
                        </schema:AddReceiptLinesResponse>
                        """;
        }
    }
}
