﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.Suspend
{
    /// <summary>
    /// Respuesta cuando no esta disponible el comando suspender
    /// </summary>
    public class SuspendTransactionResponseError : Respuesta
    {
        public int RequestID { get; set; }
        public string Message { get; set; }
        public string ErrorCode { get; set; }
        private string _xml;

        public SuspendTransactionResponseError(int sessionId,
                                               TipoMensaje messageType,
                                               int requestID,
                                               string message,
                                               string errorCode) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Message = message;
            ErrorCode = errorCode;
        }

        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:SuspendTransactionResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <SuspendTransactionResult>
                            <RequestID>{RequestID}</RequestID>
                            <ExceptionResult>
                              <Message>{Message}</Message>
                              <ErrorCode>{ErrorCode}</ErrorCode>
                            </ExceptionResult>
                          </SuspendTransactionResult>
                        </schema:SuspendTransactionResponse>
                        """;

        }
    }
}
