﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML.TerminateLane
{
    /// <summary>
    /// Respuesta para cerrar la lane 
    /// </summary>
    public class TerminateResponse : Respuesta
    {
        public bool RequestID { get; set; }
        private string _xml;

        public TerminateResponse(int sessionId,
                                 TipoMensaje messageType, 
                                 bool requestID) : base(sessionId, messageType)
        {
            RequestID = requestID;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:TerminateResponse xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <TerminateResult>
                            <RequestID>{RequestID}</RequestID>
                          </TerminateResult>
                        </schema:TerminateResponse>
                        """;
        }
    }
}
