﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    /// <summary>
    /// Respuesta a petición de agregar item - (TotalsEvent)
    /// Tambien se usa para la segunda respuesta de finalizar y pagar
    /// </summary>
    public class TotalsEventResponse : Respuesta
    {
        public int RequestID { get; set; }
        public string Key { get; set; }
        public int Value { get; set; }
        public string Total { get; set; }
        public string SubTotal { get; set; }
        public string Tax { get; set; }
        public string BalanceDue { get; set; }
        public string ChangeDue { get; set; }
        public string FoodstampChangeDue { get; set; }
        public string FoodstampTotal { get; set; }
        public string FoodstampBalanceDue { get; set; }
        public string CouponTotal { get; set; }
        public int TotalItems { get; set; }
        public int TotalCoupons { get; set; }
        public string TotalSavings { get; set; }
        public string TenderApplied { get; set; }
        private string _xml;

        public TotalsEventResponse(int sessionId,
                                 TipoMensaje messageType,
                                 int requestID,
                                 string total,
                                 string subTotal,
                                 string tax,
                                 string balanceDue,
                                 string changeDue,
                                 string foodstampChangeDue,
                                 string foodstampTotal,
                                 string foodstampBalanceDue,
                                 string couponTotal,
                                 int totalItems,
                                 int totalCoupons,
                                 string totalSavings,
                                 string tenderApplied) : base(sessionId, messageType)
        {
            RequestID = requestID;
            //Key = key;
            //Value = value;
            Total = total;
            SubTotal = subTotal;
            Tax = tax;
            BalanceDue = balanceDue;
            ChangeDue = changeDue;
            FoodstampChangeDue = foodstampChangeDue;
            FoodstampTotal = foodstampTotal;
            FoodstampBalanceDue = foodstampBalanceDue;
            CouponTotal = couponTotal;
            TotalItems = totalItems;
            TotalCoupons = totalCoupons;
            TotalSavings = totalSavings;
            TenderApplied = tenderApplied;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:TotalsEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                        <RequestID>{RequestID}</RequestID>
                        <TransactionTotals>
                            <Total>{Total}</Total>
                            <SubTotal>{SubTotal}</SubTotal>
                            <Tax>{Tax}</Tax>
                            <BalanceDue>{BalanceDue}</BalanceDue>
                            <ChangeDue>{ChangeDue}</ChangeDue>
                            <FoodstampChangeDue>{FoodstampChangeDue}</FoodstampChangeDue>
                            <FoodstampTotal>{FoodstampTotal}</FoodstampTotal>
                            <FoodstampBalanceDue>{FoodstampBalanceDue}</FoodstampBalanceDue>
                            <CouponTotal>{CouponTotal}</CouponTotal>
                            <TotalItems>{TotalItems}</TotalItems>
                            <TotalCoupons>{TotalCoupons}</TotalCoupons>
                            <TotalSavings>{TotalSavings}</TotalSavings>
                            <TenderApplied>{TenderApplied}</TenderApplied>
                        </TransactionTotals>
                        </schema:TotalsEvent>
                        """;
        }
    }
}
