﻿using EvaPosSrvDTO;
using EvaPosSrvResp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace EvaPOS_API_FRAME.RespuestasXML
{
    public class TransactionStatusEvent : Respuesta
    {
        public int RequestID { get; set; }
        public string Status { get; set; }
        public int ID { get; set; }
        public string Type { get; set; }
        public string Category { get; set; }
        public string Date { get; set; }
        public string Time { get; set; }
        private string _xml;

        public TransactionStatusEvent(int sessionId,
                                      TipoMensaje messageType,
                                      int requestID, 
                                      string status, 
                                      int iD, 
                                      string type, 
                                      string category, 
                                      string date, 
                                      string time) : base(sessionId, messageType)
        {
            RequestID = requestID;
            Status = status;
            ID = iD;
            Type = type;
            Category = category;
            Date = date;
            Time = time;
        }
        public override string TextoXML
        {
            get => _xml = $"""
                        <?xml version="1.0" encoding="UTF-8"?>
                        <schema:TransactionStatusEvent xmlns:schema="http://bc.si.retail.ibm.com/POSBCSchema">
                          <RequestID>{RequestID}</RequestID>
                          <TransactionStatus>
                            <Status>{Status}</Status>
                            <ID>{ID}</ID>
                            <Type>{Type}</Type>
                            <Category>{Category}</Category>
                            <Date>{Date}</Date>
                            <Time>{Time}</Time>
                          </TransactionStatus>
                        </schema:TransactionStatusEvent>
                        """;
        }

        public override string ToString()
        {
            return String.Format("TransactionStatusEvent RequestID {0}", RequestID);
        }
    }
}
