namespace gatewayGKTest;
using Xunit;
using Xunit.Abstractions;
using Xunit.Sdk;
using GatewaySCO;
using gatewayGK.ComandosGk;
using SCOGateway.POSGk;
using EvaPosSrvDTO;


public class LoginGkTest
{
    private readonly ITestOutputHelper output;
    private readonly IMessageSink diagnosticMessageSink;
    // Constructor usado para inicializar test.
    public LoginGkTest(ITestOutputHelper output, IMessageSink diagnosticMessageSink)
    {
        this.output = output;
        this.diagnosticMessageSink = diagnosticMessageSink;

        string[] args = { };
        var p = new GatewaySCO.Program();
        // Esto inicializa el entorno.
        var config = p.LeeConfiguracion(args);
    }

    //[Fact]
    public void Login()
    {
        var request = new InitializeRequestDTO(0, new TipoMensaje());
        request.TerminalNumber = 1;
        request.OperatorID = "";
        request.Recovery = false;

        var cmd = new InitializeRequestCmdGk();
        cmd.CargaDTO(request);
        cmd.Ejecutar();

        // Ejecutado el comando, el entorno debe estar inicializado con el id de sesión GK.
        string sessionId = Entorno<EntornoGK>.Instancia.get().posSessionId;
        output.WriteLine("sessionId:", sessionId);

        var message = new DiagnosticMessage("sessionId:", sessionId);
        diagnosticMessageSink.OnMessage(message);

        Assert.True(sessionId.Length > 0);
    }
}
