namespace gatewayGKTest;
using Xunit;
using Xunit.Abstractions;
using Xunit.Sdk;
using GatewaySCO;


public class ReplaceValuesInStringTest
{
    [Fact]
    public void ReplaceOk()
    {
        string _jsonReq = """
            {
                "operationConfiguration": {
                    "forceQuantityInput": false,
                    "pricePositionLimit": 10000,
                    "pricePositionZeroAllowed": true,
                    "priceTransactionLimit": -1,
                    "priceDifferencePercentPositionLimit": 100,
                    "priceDifferenceAbsolutePositionLimit": 999999,
                    "priceDifferenceLimitExceedAction": "Warn",
                    "priceNegDifferenceLimitExceedAction": "Warn",
                    "closeCurrent": "Required",
                    "closePrevious": "Required",
                    "filterResult": true,
                    "allowedWithWeight": true,
                    "allowedWithLength": true,
                    "allowedWithArea": true,
                    "allowedWithVolume": true,
                    "allowedWithMeasure": true,
                    "maximumQuantity": 999999,
                    "minimumQuantity": 1,
                    "quantityInputOrder": "BeforeOrAfter",
                    "priceInputOrder": "BeforeOrAfter",
                    "quantityLimitExceedAction": "Warn",
                    "amountLimitExceedAction": "Warn",
                    "weightUnitFactor": 0,
                    "measureUnitFactor": 0,
                    "priceDeviationType": "All",
                    "priceNegDeviationType": "All",
                    "xXCustom08": "string",
                    "xXCustom10": "string",
                    "xXCustom09": "string",
                    "xXCustom07": "string",
                    "xXCustom05": "string",
                    "xXCustom06": "string",
                    "xXCustom11": "string",
                    "xXCustom12": "string",
                    "xXCustom13": "string",
                    "xXCustom14": "string",
                    "xXCustom15": "string",
                    "xXCustom03": "string",
                    "xXCustom02": "string",
                    "xXCustom04": "string",
                    "xXCustom01": "string"
                },
                "barcode": "<|31100009|>",
                "salesRestrictionsCheckNeeded": false,
                "priceVariant": "Actual",
                "itemEntryConfig": {
                    "forceQuantityInput": <|true|>,
                    "pricePositionLimit": <|0|>,
                    "pricePositionZeroAllowed": true,
                    "priceTransactionLimit": 0,
                    "priceDifferencePercentPositionLimit": 0,
                    "priceDifferenceAbsolutePositionLimit": 0,
                    "priceDifferenceLimitExceedAction": "Warn",
                    "priceNegDifferenceLimitExceedAction": "Warn",
                    "closeCurrent": "Required",
                    "closePrevious": "Required",
                    "filterResult": true,
                    "allowedWithWeight": true,
                    "allowedWithLength": true,
                    "allowedWithArea": true,
                    "allowedWithVolume": true,
                    "allowedWithMeasure": true,
                    "maximumQuantity": 0,
                    "minimumQuantity": 0,
                    "quantityInputOrder": "BeforeOrAfter",
                    "priceInputOrder": "BeforeOrAfter",
                    "quantityLimitExceedAction": "Warn",
                    "weightUnitFactor": 0,
                    "measureUnitFactor": 0,
                    "priceDeviationType": "All",
                    "priceNegDeviationType": "All",
                    "xXCustom01": "string",
                    "xXCustom02": "string",
                    "xXCustom03": "string",
                    "xXCustom04": "string",
                    "xXCustom05": "string",
                    "xXCustom06": "string",
                    "xXCustom07": "string",
                    "xXCustom08": "string",
                    "xXCustom09": "string",
                    "xXCustom10": "string",
                    "xXCustom11": "string",
                    "xXCustom12": "string",
                    "xXCustom13": "string",
                    "xXCustom14": "string",
                    "xXCustom15": "string"
                },
                "entryMethodCode": "Keyed",
                "keyedOnline": true
            }
            """;

        string _jsonReq2 = """
            {
                "operationConfiguration": {
                    "forceQuantityInput": false,
                    "pricePositionLimit": 10000,
                    "pricePositionZeroAllowed": true,
                    "priceTransactionLimit": -1,
                    "priceDifferencePercentPositionLimit": 100,
                    "priceDifferenceAbsolutePositionLimit": 999999,
                    "priceDifferenceLimitExceedAction": "Warn",
                    "priceNegDifferenceLimitExceedAction": "Warn",
                    "closeCurrent": "Required",
                    "closePrevious": "Required",
                    "filterResult": true,
                    "allowedWithWeight": true,
                    "allowedWithLength": true,
                    "allowedWithArea": true,
                    "allowedWithVolume": true,
                    "allowedWithMeasure": true,
                    "maximumQuantity": 999999,
                    "minimumQuantity": 1,
                    "quantityInputOrder": "BeforeOrAfter",
                    "priceInputOrder": "BeforeOrAfter",
                    "quantityLimitExceedAction": "Warn",
                    "amountLimitExceedAction": "Warn",
                    "weightUnitFactor": 0,
                    "measureUnitFactor": 0,
                    "priceDeviationType": "All",
                    "priceNegDeviationType": "All",
                    "xXCustom08": "string",
                    "xXCustom10": "string",
                    "xXCustom09": "string",
                    "xXCustom07": "string",
                    "xXCustom05": "string",
                    "xXCustom06": "string",
                    "xXCustom11": "string",
                    "xXCustom12": "string",
                    "xXCustom13": "string",
                    "xXCustom14": "string",
                    "xXCustom15": "string",
                    "xXCustom03": "string",
                    "xXCustom02": "string",
                    "xXCustom04": "string",
                    "xXCustom01": "string"
                },
                "barcode": "31100009",
                "salesRestrictionsCheckNeeded": false,
                "priceVariant": "Actual",
                "itemEntryConfig": {
                    "forceQuantityInput": true,
                    "pricePositionLimit": 0,
                    "pricePositionZeroAllowed": true,
                    "priceTransactionLimit": 0,
                    "priceDifferencePercentPositionLimit": 0,
                    "priceDifferenceAbsolutePositionLimit": 0,
                    "priceDifferenceLimitExceedAction": "Warn",
                    "priceNegDifferenceLimitExceedAction": "Warn",
                    "closeCurrent": "Required",
                    "closePrevious": "Required",
                    "filterResult": true,
                    "allowedWithWeight": true,
                    "allowedWithLength": true,
                    "allowedWithArea": true,
                    "allowedWithVolume": true,
                    "allowedWithMeasure": true,
                    "maximumQuantity": 0,
                    "minimumQuantity": 0,
                    "quantityInputOrder": "BeforeOrAfter",
                    "priceInputOrder": "BeforeOrAfter",
                    "quantityLimitExceedAction": "Warn",
                    "weightUnitFactor": 0,
                    "measureUnitFactor": 0,
                    "priceDeviationType": "All",
                    "priceNegDeviationType": "All",
                    "xXCustom01": "string",
                    "xXCustom02": "string",
                    "xXCustom03": "string",
                    "xXCustom04": "string",
                    "xXCustom05": "string",
                    "xXCustom06": "string",
                    "xXCustom07": "string",
                    "xXCustom08": "string",
                    "xXCustom09": "string",
                    "xXCustom10": "string",
                    "xXCustom11": "string",
                    "xXCustom12": "string",
                    "xXCustom13": "string",
                    "xXCustom14": "string",
                    "xXCustom15": "string"
                },
                "entryMethodCode": "Keyed",
                "keyedOnline": true
            }
            """;

        string barcode = "31100009";
        bool forceQuantityInput = true;
        int pricePositionLimit = 0;
        var s = Util.ReplaceValuesInString(_jsonReq, barcode, forceQuantityInput, pricePositionLimit);

        Assert.True(_jsonReq2 == s);
    }

    [Fact]
    public void NoReplace()
    {
        string s1 = "No hay nada que remplazar.";

        Assert.True(s1 == Util.ReplaceValuesInString(s1));
    }

    [Fact]
    public void ReplaceException()
    {
        string s1 = "Remplazar <|uno|>, <|dos|> y <|tres|>.";
        string uno = "uno";
        int dos = 2;
        bool tres = true;
        int cuatro = 1;
        //string s2 = "Remplazar uno, 2 y true.";

        Assert.True(s1 == Util.ReplaceValuesInString(s1, uno, dos, tres));
        Assert.Throws<ArgumentException>(() => Util.ReplaceValuesInString(s1, uno, dos));
        Assert.Throws<ArgumentException>(() => Util.ReplaceValuesInString(s1, uno, dos, tres, cuatro));
    }
}
