﻿using System.Net;
using System.Net.Sockets;
using System.Text;

namespace gatewayPruebasECO_POSBC;

// Activa servidor para pruebas, acepta mensajes que retorna identicos.
public class SocketServer
{
    private const int Port = 6698; // Puerto en el que el servidor escuchará

    public static void Main()
    {
        Socket? listener = null;
        try
        {
            // Crear un socket de escucha
            listener = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            listener.Bind(new IPEndPoint(IPAddress.Any, Port));
            listener.Listen(10);
            Console.WriteLine($"Servidor ECO_POSBC escuchando en el puerto {Port}...");

            // Aceptar una conexión de cliente
            using Socket clientSocket = listener.Accept();
            Console.WriteLine("Cliente conectado.");
            while (true)
            {
                Console.WriteLine("..esperando mensaje.");
                // Recibir el mensaje del cliente
                byte[] buffer = new byte[4096];
                int bytesRead = clientSocket.Receive(buffer);
                string message = Encoding.UTF8.GetString(buffer, 0, bytesRead);
                Console.WriteLine($"Mensaje recibido: {message}");

                // Enviar el mismo mensaje de vuelta al cliente
                clientSocket.Send(buffer, bytesRead, SocketFlags.None);
                Console.WriteLine("Mensaje enviado de vuelta al cliente.");
            }
        }
        catch (SocketException e)
        {
            Console.WriteLine($"Error de socket: {e.Message}");
        }
        finally
        {
            // Cerrar el socket de escucha
            listener?.Close();
        }
    }
}

