namespace POSGkSwaggerModel
{
    /// <summary>
    /// BusinessUnitDO &lt;p&gt;A retail store, distribution center or administration center at which the retailer conducts retail operations.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareGkrApiServerMdBusinessUnitDtoDomBusinessUnitDO	{
        /// <summary>
        /// &lt;p&gt;The status of business unit. Possible values include the codes for enabled, disabled, scheduled for deletion, deleted.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The status of business unit. Possible values include the codes for enabled, disabled, scheduled for deletion, deleted.&lt;br /&gt;&lt;/p&gt;</value>
        public businessUnitStatusCodeEnum? businessUnitStatusCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Getter for inner key class.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Getter for inner key class.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdBusinessUnitDtoDomBusinessUnitDOkey key { get; init; }
        /// <summary>
        /// &lt;p&gt;External identifier for the business unit.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;External identifier for the business unit.&lt;br /&gt;&lt;/p&gt;</value>
        public string externalBusinessUnitID { get; init; }
        /// <summary>
        /// &lt;p&gt;ID of the parent business unit group&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ID of the parent business unit group&lt;br /&gt;&lt;/p&gt;</value>
        public string parentBusinessUnitGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;External ID of the parent business unit group&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;External ID of the parent business unit group&lt;br /&gt;&lt;/p&gt;</value>
        public string parentExternalBusinessUnitGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;A unique internal identifier for a level within the business unit grouping hierarchy.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A unique internal identifier for a level within the business unit grouping hierarchy.&lt;br /&gt;&lt;/p&gt;</value>
        public string businessUnitGroupLevelID { get; init; }
        /// <summary>
        /// &lt;p&gt;Name of the level within the business unit grouping hierarchy (external identifier of level).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Name of the level within the business unit grouping hierarchy (external identifier of level).&lt;br /&gt;&lt;/p&gt;</value>
        public string externalBusinessUnitGroupLevelID { get; init; }
        /// <summary>
        /// &lt;p&gt;Global location number&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Global location number&lt;br /&gt;&lt;/p&gt;</value>
        public string globalLocationNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;VAT registration number&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;VAT registration number&lt;br /&gt;&lt;/p&gt;</value>
        public string vatRegistrationNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The country code of the store.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The country code of the store.&lt;br /&gt;&lt;/p&gt;</value>
        public string isoCountryCode { get; init; }
        /// <summary>
        /// &lt;p&gt;SAP time zone code&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;SAP time zone code&lt;br /&gt;&lt;/p&gt;</value>
        public string timeZoneCode { get; init; }
        /// <summary>
        /// &lt;p&gt;ID of the time zone in the Java format (e.g. &#39;US/Eastern&#39;, &#39;Europe/Prague&#39;)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ID of the time zone in the Java format (e.g. &#39;US/Eastern&#39;, &#39;Europe/Prague&#39;)&lt;br /&gt;&lt;/p&gt;</value>
        public string timeZoneLongID { get; init; }
        /// <summary>
        /// &lt;p&gt;ISO-Code of the language which is used in the business unit&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ISO-Code of the language which is used in the business unit&lt;br /&gt;&lt;/p&gt;</value>
        public string languageID { get; init; }
        /// <summary>
        /// &lt;p&gt;The name of the business unit&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The name of the business unit&lt;br /&gt;&lt;/p&gt;</value>
        public string name { get; init; }
        /// <summary>
        /// &lt;p&gt;The surrogate name of the business unit&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The surrogate name of the business unit&lt;br /&gt;&lt;/p&gt;</value>
        public string surrogateName { get; init; }
        /// <summary>
        /// &lt;p&gt;Effective date of the assignment to the GK&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Effective date of the assignment to the GK&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string gkEffectiveDate { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines the assignment to the RG business unit group hierarchy&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines the assignment to the RG business unit group hierarchy&lt;br /&gt;&lt;/p&gt;</value>
        public bool? regionFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines the assignment to the SEH business unit group hierarchy&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines the assignment to the SEH business unit group hierarchy&lt;br /&gt;&lt;/p&gt;</value>
        public bool? independentRetailerFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;ID of the parent business unit group with the function code &#39;OMS&#39;&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ID of the parent business unit group with the function code &#39;OMS&#39;&lt;br /&gt;&lt;/p&gt;</value>
        public string ownerOfMultipleStoresParentID { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the GK system is installed in the store or not&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the GK system is installed in the store or not&lt;br /&gt;&lt;/p&gt;</value>
        public bool? gkSystemFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of the main currency of the retail store.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of the main currency of the retail store.&lt;br /&gt;&lt;/p&gt;</value>
        public string mainCurrencyID { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether this store provides data to the GFK organization&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether this store provides data to the GFK organization&lt;br /&gt;&lt;/p&gt;</value>
        public bool? exportToGfkFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The size of the retail store. This is usually split by the non-sales and sales areas.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The size of the retail store. This is usually split by the non-sales and sales areas.&lt;br /&gt;&lt;/p&gt;</value>
        public double? size { get; init; }
        /// <summary>
        /// &lt;p&gt;The size of the selling floor. In a large store this is further split by the sales floor and by the merchandise departments.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The size of the selling floor. In a large store this is further split by the sales floor and by the merchandise departments.&lt;br /&gt;&lt;/p&gt;</value>
        public double? sellingAreaSize { get; init; }
        /// <summary>
        /// &lt;p&gt;Code of the MerchandiseHierarchyFunction which is relevant for that store&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Code of the MerchandiseHierarchyFunction which is relevant for that store&lt;br /&gt;&lt;/p&gt;</value>
        public string merchandiseHierarchyFunctionCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Indicates if the prices include all applicable sales taxes or not.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Indicates if the prices include all applicable sales taxes or not.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? includesSalesTaxFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;The company&#39;s tax number given by the tax office (this is not the sales tax ID).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The company&#39;s tax number given by the tax office (this is not the sales tax ID).&lt;br /&gt;&lt;/p&gt;</value>
        public string taxNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The second currency which is e.g. to be shown in the receipt total and to be printed on the receipt (during the time of changing of a local currency to EURO)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The second currency which is e.g. to be shown in the receipt total and to be printed on the receipt (during the time of changing of a local currency to EURO)&lt;br /&gt;&lt;/p&gt;</value>
        public string alternateISOCurrencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The name of the unit which is mainly used for weighing information&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The name of the unit which is mainly used for weighing information&lt;br /&gt;&lt;/p&gt;</value>
        public string mainWeighingUnit { get; init; }
        /// <summary>
        /// &lt;p&gt;An organizational unit responsible for procuring materials or services for one or more plants and for negotiating general conditions of purchase with suppliers.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;An organizational unit responsible for procuring materials or services for one or more plants and for negotiating general conditions of purchase with suppliers.&lt;br /&gt;&lt;/p&gt;</value>
        public string purchasingOrganization { get; init; }
        /// <summary>
        /// &lt;p&gt;List of receiving locations.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of receiving locations.&lt;br /&gt;&lt;/p&gt;</value>
        public List<string> ReceiverLocationList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of company codes of the store.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of company codes of the store.&lt;br /&gt;&lt;/p&gt;</value>
        public List<string> CompanyCodeList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of bank accounts&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of bank accounts&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerMdBusinessUnitDtoDomBankAccount> BankAccountList { get; init; }
        /// <summary>
        /// &lt;p&gt;ID of the party information&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ID of the party information&lt;br /&gt;&lt;/p&gt;</value>
        public string partyID { get; init; }
        /// <summary>
        /// &lt;p&gt;Reference to the party structure&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Reference to the party structure&lt;br /&gt;&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdpartyDtoDompartyDO party { get; init; }
        /// <summary>
        /// &lt;p&gt;List of contacts&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of contacts&lt;br /&gt;&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdcontactDtoDomcontactDO contact { get; init; }
        /// <summary>
        /// &lt;p&gt;List of translations for the business unit.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of translations for the business unit.&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareGkrApiServerCommonTranslationsDtoDomTranslationDO> TranslationList { get; init; }
        /// <summary>
        /// &lt;p&gt;Internal identification of the import package (e.g. IDoc file). The identification is used for monitoring purposes.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Internal identification of the import package (e.g. IDoc file). The identification is used for monitoring purposes.&lt;br /&gt;&lt;/p&gt;</value>
        public string packageID { get; init; }
        /// <summary>
        /// &lt;p&gt;Identifier of an organizational unit responsible for the sale of certain products or services.&lt;br /&gt; The responsibility of a sales organization may include legal liability for products and customer claims.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identifier of an organizational unit responsible for the sale of certain products or services.&lt;br /&gt; The responsibility of a sales organization may include legal liability for products and customer claims.&lt;br /&gt;&lt;/p&gt;</value>
        public string salesOrganizationID { get; init; }
        /// <summary>
        /// &lt;p&gt;Distribution channel is the way in which products or services reach the customer.&lt;br /&gt; Typical examples of distribution channels are wholesale, retail, or direct sales.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Distribution channel is the way in which products or services reach the customer.&lt;br /&gt; Typical examples of distribution channels are wholesale, retail, or direct sales.&lt;br /&gt;&lt;/p&gt;</value>
        public string distributionChannelTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The UTC0 date and time when the business unit was finally deleted&lt;br /&gt;&lt;/p&gt; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>&lt;p&gt;The UTC0 date and time when the business unit was finally deleted&lt;br /&gt;&lt;/p&gt; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? deleteTimestampUTC0 { get; init; }
        /// <summary>
        /// &lt;p&gt;Geo positional co-ordinates of a business unit specifying its latitude using Decimal Degrees system (ISO 6709).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Geo positional co-ordinates of a business unit specifying its latitude using Decimal Degrees system (ISO 6709).&lt;br /&gt;&lt;/p&gt;</value>
        public double? latitudeDecimalDegrees { get; init; }
        /// <summary>
        /// &lt;p&gt;Geo positional co-ordinates of a business unit specifying its longitude using Decimal Degrees system (ISO 6709).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Geo positional co-ordinates of a business unit specifying its longitude using Decimal Degrees system (ISO 6709).&lt;br /&gt;&lt;/p&gt;</value>
        public double? longitudeDecimalDegrees { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;</value>
        public string tid { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom17 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom30 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom01 { get; init; }
	}
}
