namespace POSGkSwaggerModel
{
    /// <summary>
    /// RetailTransactionCustomerGroupAssignment.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoRetailTransactionCustomerGroupAssignmentKey	{
        /// <summary>
        /// A unique system assigned identifier for a group of BusinessUnits.
        /// </summary>
        /// <value>A unique system assigned identifier for a group of BusinessUnits.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. 
        /// </summary>
        /// <value>A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. </value>
        public string transactionID { get; init; }
        /// <summary>
        /// A unique system assigned identifier for the Customer. 
        /// </summary>
        /// <value>A unique system assigned identifier for the Customer. </value>
        public string customerID { get; init; }
        /// <summary>
        /// The customer type code
        /// </summary>
        /// <value>The customer type code</value>
        public string addressTypeCode { get; init; }
        /// <summary>
        /// A unique identification number assigned to a customer group 
        /// </summary>
        /// <value>A unique identification number assigned to a customer group </value>
        public string customerGroupID { get; init; }
	}
}
