namespace POSGkSwaggerModel
{
    /// <summary>
    /// RetailTransactionLineItemI18NText.Key Inner class for composite key attributes
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoRetailTransactionLineItemI18NTextKey	{
        /// <summary>
        /// A unique system assigned identifier for a group of BusinessUnits.
        /// </summary>
        /// <value>A unique system assigned identifier for a group of BusinessUnits.</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. 
        /// </summary>
        /// <value>A universally unique identifier (UUID) for the Transaction. This may be assembled from alternate key members. </value>
        public string transactionID { get; init; }
        /// <summary>
        /// The sequence number of line item within the context of this RetailTransaction. 
        /// </summary>
        /// <value>The sequence number of line item within the context of this RetailTransaction. </value>
        public int? retailTransactionLineItemSequenceNumber { get; init; }
        /// <summary>
        /// Line number (incremental counter) of the text 
        /// </summary>
        /// <value>Line number (incremental counter) of the text </value>
        public int? textSequenceNumber { get; init; }
        /// <summary>
        /// A combination of ISO-639-1 and ISO-3661-1 to denote a lanuage as spoken in a particular country. 
        /// </summary>
        /// <value>A combination of ISO-639-1 and ISO-3661-1 to denote a lanuage as spoken in a particular country. </value>
        public string languageID { get; init; }
        /// <summary>
        /// Category code of the text
        /// </summary>
        /// <value>Category code of the text</value>
        public string category { get; init; }
	}
}
