namespace POSGkSwaggerModel
{
    /// <summary>
    /// Transaction &lt;emph&gt;undocumented&lt;/emph&gt;
    /// </summary>
    public record comGkSoftwareGkrApiTxpoolDtoTransaction	{
        /// <summary>
        /// &lt;p&gt;Getter for inner key class.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Getter for inner key class.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiTxpoolDtoTransactionkey key { get; init; }
        /// <summary>
        /// A unique, automatically assigned number used to identify a workstation OPERATOR. 
        /// </summary>
        /// <value>A unique, automatically assigned number used to identify a workstation OPERATOR. </value>
        public string operatorID { get; init; }
        /// <summary>
        /// The unique identifier for the WORKSTATION. 
        /// </summary>
        /// <value>The unique identifier for the WORKSTATION. </value>
        public string workstationID { get; init; }
        /// <summary>
        /// The store id
        /// </summary>
        /// <value>The store id</value>
        public string businessUnitID { get; init; }
        /// <summary>
        /// The calendar date of the BusinessDay. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>The calendar date of the BusinessDay. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string businessDayDate { get; init; }
        /// <summary>
        /// The sequence number of the transaction (incremental number for each workstation). It is formatted according to minimum and maximum value and it could be reset every day to minimum value. So in comparison to InternalSequenceNumber it must not be unique for business unit and workstation.It is used for export, reporting, search and display.
        /// </summary>
        /// <value>The sequence number of the transaction (incremental number for each workstation). It is formatted according to minimum and maximum value and it could be reset every day to minimum value. So in comparison to InternalSequenceNumber it must not be unique for business unit and workstation.It is used for export, reporting, search and display.</value>
        public int? sequenceNumber { get; init; }
        /// <summary>
        /// A code to denote the type of Transaction.
        /// </summary>
        /// <value>A code to denote the type of Transaction.</value>
        public string transactionTypeCode { get; init; }
        /// <summary>
        /// The time and date a transaction is initiated. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>The time and date a transaction is initiated. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string beginDateTimestamp { get; init; }
        /// <summary>
        /// The time and date stamp a transaction is completed. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>The time and date stamp a transaction is completed. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string endDateTimestamp { get; init; }
        /// <summary>
        /// A flag denoting that this entire transaction has been cancelled before it was completed at the POS. 
        /// </summary>
        /// <value>A flag denoting that this entire transaction has been cancelled before it was completed at the POS. </value>
        public bool? cancelledFlag { get; init; }
        /// <summary>
        /// Defines if the transaction was suspended.
        /// </summary>
        /// <value>Defines if the transaction was suspended.</value>
        public bool? suspendedFlag { get; init; }
        /// <summary>
        /// A flag to signify whether the transaction was created in training mode.
        /// </summary>
        /// <value>A flag to signify whether the transaction was created in training mode.</value>
        public bool? trainingFlag { get; init; }
        /// <summary>
        /// A code that indicates the online/offline state when transaction was completed.
        /// </summary>
        /// <value>A code that indicates the online/offline state when transaction was completed.</value>
        public string keyedOfflineFlag { get; init; }
        /// <summary>
        /// A unique retailer defined reason code for an action that is taken (or not taken) at a Workstation.
        /// </summary>
        /// <value>A unique retailer defined reason code for an action that is taken (or not taken) at a Workstation.</value>
        public string reasonCode { get; init; }
        /// <summary>
        /// A narrative description describing the uses of the retailer assigned reason code. Corresponds to Reason.Description
        /// </summary>
        /// <value>A narrative description describing the uses of the retailer assigned reason code. Corresponds to Reason.Description</value>
        public string reasonDescription { get; init; }
        /// <summary>
        /// A unique system-assigned identifier for the Worker.
        /// </summary>
        /// <value>A unique system-assigned identifier for the Worker.</value>
        public string workerID { get; init; }
        /// <summary>
        /// The worker&#39;s first name
        /// </summary>
        /// <value>The worker&#39;s first name</value>
        public string workerFirstName { get; init; }
        /// <summary>
        /// The worker&#39;s last name
        /// </summary>
        /// <value>The worker&#39;s last name</value>
        public string workerLastName { get; init; }
        /// <summary>
        /// The software version which was used in order to create the transaction.
        /// </summary>
        /// <value>The software version which was used in order to create the transaction.</value>
        public string softwareVersion { get; init; }
        /// <summary>
        /// Number for suspending, can be used for multiple transactions
        /// </summary>
        /// <value>Number for suspending, can be used for multiple transactions</value>
        public string suspendNumber { get; init; }
        /// <summary>
        /// The sequence number of the transaction (incremental number for each workstation). It is unique for business unit and workstation.
        /// </summary>
        /// <value>The sequence number of the transaction (incremental number for each workstation). It is unique for business unit and workstation.</value>
        public int? internalSequenceNumber { get; init; }
        /// <summary>
        /// The sequence number being created either by the POS, the fiscal printer, or other device used for fiscalization
        /// </summary>
        /// <value>The sequence number being created either by the POS, the fiscal printer, or other device used for fiscalization</value>
        public string fiscalSequenceNumber { get; init; }
        /// <summary>
        /// Determines whether this is a fiscal transaction.
        /// </summary>
        /// <value>Determines whether this is a fiscal transaction.</value>
        public bool? fiscalFlag { get; init; }
        /// <summary>
        /// The fiscal day counter
        /// </summary>
        /// <value>The fiscal day counter</value>
        public string fiscalDayNumber { get; init; }
        /// <summary>
        /// The identifier of the fiscal printer
        /// </summary>
        /// <value>The identifier of the fiscal printer</value>
        public string fiscalPrinterID { get; init; }
        /// <summary>
        /// Fiscal signature of the transaction.
        /// </summary>
        /// <value>Fiscal signature of the transaction.</value>
        public string fiscalSignature { get; init; }
        /// <summary>
        /// The timestamp which is relevant for the transaction processing. Depending on configuration, this can be the BeginDateTimestamp or the EndDateTimestamp. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>The timestamp which is relevant for the transaction processing. Depending on configuration, this can be the BeginDateTimestamp or the EndDateTimestamp. ; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string transactionTimestamp { get; init; }
        /// <summary>
        /// The UTC0 time and date a transaction is initiated. ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>The UTC0 time and date a transaction is initiated. ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? beginDateTimestampUTC0 { get; init; }
        /// <summary>
        /// The UTC0 time and date stamp a transaction is completed. ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>The UTC0 time and date stamp a transaction is completed. ; UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? endDateTimestampUTC0 { get; init; }
        /// <summary>
        /// The UTC0 timestamp which is relevant for the transaction processing. Depending on configuration, this can be the BeginDateTimestampUTC0 or the EndDateTimestampUTC0. UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)
        /// </summary>
        /// <value>The UTC0 timestamp which is relevant for the transaction processing. Depending on configuration, this can be the BeginDateTimestampUTC0 or the EndDateTimestampUTC0. UTC0 date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#39; (with timezone)</value>
        public DateTime? transactionTimestampUTC0 { get; init; }
        /// <summary>
        /// List of additional printouts
        /// </summary>
        /// <value>List of additional printouts</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionAdditionalPrintout> TransactionAdditionalPrintoutList { get; init; }
        /// <summary>
        /// List of associated transactions
        /// </summary>
        /// <value>List of associated transactions</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionAssociation> TransactionAssociationList { get; init; }
        /// <summary>
        /// List of binary data
        /// </summary>
        /// <value>List of binary data</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionBinaryData> TransactionBinaryDataList { get; init; }
        /// <summary>
        /// List of transaction categories
        /// </summary>
        /// <value>List of transaction categories</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionCategory> TransactionCategoryList { get; init; }
        /// <summary>
        /// List of transaction extensions
        /// </summary>
        /// <value>List of transaction extensions</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionExtension> TransactionExtensionList { get; init; }
        /// <summary>
        /// List of data for authorization related to transaction level
        /// </summary>
        /// <value>List of data for authorization related to transaction level</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionResourceOverride> TransactionResourceOverrideList { get; init; }
        /// <summary>
        /// WorkstationID were the transaction was finalized.
        /// </summary>
        /// <value>WorkstationID were the transaction was finalized.</value>
        public string endWorkstationID { get; init; }
        /// <summary>
        /// List of audit events
        /// </summary>
        /// <value>List of audit events</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionAuditEvent> TransactionAuditEventList { get; init; }
        /// <summary>
        /// List of timer entries
        /// </summary>
        /// <value>List of timer entries</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTransactionTimer> TransactionTimerList { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom08 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom10 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom09 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom07 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom06 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom11 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom12 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom13 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom14 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom15 { get; init; }
        /// <summary>
        /// retail transaction data
        /// </summary>
        /// <value>retail transaction data</value>
        public List<comGkSoftwareGkrApiTxpoolDtoRetailTransaction> RetailTransactionList { get; init; }
        /// <summary>
        /// control transaction data
        /// </summary>
        /// <value>control transaction data</value>
        public List<comGkSoftwareGkrApiTxpoolDtoControlTransaction> ControlTransactionList { get; init; }
        /// <summary>
        /// tender control transaction data
        /// </summary>
        /// <value>tender control transaction data</value>
        public List<comGkSoftwareGkrApiTxpoolDtoTenderControlTransaction> TenderControlTransactionList { get; init; }
        /// <summary>
        /// Main currency of the store
        /// </summary>
        /// <value>Main currency of the store</value>
        public string isocurrencyCode { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// Customizable information
        /// </summary>
        /// <value>Customizable information</value>
        public string xxcustom01 { get; init; }
	}
}
