namespace POSGkSwaggerModel
{
    /// <summary>
    /// EwicPaymentOperationConfig &lt;p&gt;This configuration entity defines eWIC payment related operations.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessActionEwicPaymentOperationConfig	{
        /// <summary>
        /// &lt;p&gt;This parameter defines the input amount constraint.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: InputAmountConstraint [TENDER, REQUIRED, OPTIONAL, PROHIBITED, CONFIRM]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Tender as &#39;&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Required as &#39;01&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Optional as &#39;02&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Prohibited as &#39;03&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Confirm as &#39;04&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the input amount constraint.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: InputAmountConstraint [TENDER, REQUIRED, OPTIONAL, PROHIBITED, CONFIRM]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Tender as &#39;&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Required as &#39;01&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Optional as &#39;02&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Prohibited as &#39;03&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Confirm as &#39;04&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public inputAmountConstraintEnum inputAmountConstraint { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the allowed amount type code.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: AllowedAmountTypeCode [TENDER, EXACTLY, EXACTLYANDLESS, EXACTLYANDMORE, ALL]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Tender as &#39;&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Exactly as &#39;01&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;ExactlyAndLess as &#39;02&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;ExactlyAndMore as &#39;03&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;All as &#39;04&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the allowed amount type code.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: AllowedAmountTypeCode [TENDER, EXACTLY, EXACTLYANDLESS, EXACTLYANDMORE, ALL]&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Tender as &#39;&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Exactly as &#39;01&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;ExactlyAndLess as &#39;02&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;ExactlyAndMore as &#39;03&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;All as &#39;04&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public allowedAmountTypeCodeEnum allowedAmountTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the payment amount which is used by the function (in the case of fixed amounts which are assigned to keys).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the payment amount which is used by the function (in the case of fixed amounts which are assigned to keys).&lt;/p&gt;</value>
        public double? amount { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the operator should be asked to enter the amount (in an additional view).&lt;br /&gt; It is only taken into account if the amount input for the tender is &#39;optional&#39; or &#39;required&#39;.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: 01, 02&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;InputAmountConstraint &#x3D; &#39;Required 01&#39; or&lt;/li&gt;&lt;br /&gt; &lt;li&gt;InputAmountConstraint &#x3D; &#39;Optional 02&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the operator should be asked to enter the amount (in an additional view).&lt;br /&gt; It is only taken into account if the amount input for the tender is &#39;optional&#39; or &#39;required&#39;.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: 01, 02&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;InputAmountConstraint &#x3D; &#39;Required 01&#39; or&lt;/li&gt;&lt;br /&gt; &lt;li&gt;InputAmountConstraint &#x3D; &#39;Optional 02&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? askForAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the assignment to a particular tender in the master data.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the assignment to a particular tender in the master data.&lt;/p&gt;</value>
        public string tenderClassCode { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the code of the currency which is used. It overrides the currency selection.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the code of the currency which is used. It overrides the currency selection.&lt;/p&gt;</value>
        public string currencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the payment amount must be confirmed for partial payments. It is only taken into account if the amount input for the tender must be confirmed.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: 04&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;InputAmountConstraint &#x3D; &#39;Confirm 04&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the payment amount must be confirmed for partial payments. It is only taken into account if the amount input for the tender must be confirmed.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;value: 04&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;InputAmountConstraint &#x3D; &#39;Confirm 04&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? confirmPartialPayment { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the eWIC functionality is active for the store.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the eWIC functionality is active for the store.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? ewicStore { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the store takes &#39;WIC Online EBT Cards&#39;, &#39;WIC Smart Cards&#39;, or both.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: 1, 2, 3&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the store takes &#39;WIC Online EBT Cards&#39;, &#39;WIC Smart Cards&#39;, or both.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: 1, 2, 3&lt;br /&gt;&lt;/pre&gt;</value>
        public int? ewicType { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the telephone number to call for offline authorizations to State Agency.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the telephone number to call for offline authorizations to State Agency.&lt;/p&gt;</value>
        public string ewicPhone { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the number of items that may be split among a regular subcategory and a broad band subcategory in a transaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the number of items that may be split among a regular subcategory and a broad band subcategory in a transaction.&lt;/p&gt;</value>
        public int? ewicStraddled { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the number of items that may be split tendered between an eWIC tender and a customer provided tender in a transaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the number of items that may be split tendered between an eWIC tender and a customer provided tender in a transaction.&lt;/p&gt;</value>
        public int? ewicSplit { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the maximum number of items allowed to be paid for with eWIC tender in a transaction when WIC Online EBT Card is used.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the maximum number of items allowed to be paid for with eWIC tender in a transaction when WIC Online EBT Card is used.&lt;/p&gt;</value>
        public int? ewicMaxOnline { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the maximum number of items allowed to be paid for with eWIC tender in a transaction when WIC Smart Card is used.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the maximum number of items allowed to be paid for with eWIC tender in a transaction when WIC Smart Card is used.&lt;/p&gt;</value>
        public int? ewicMaxSmart { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the eWIC Merchant Identification.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the eWIC Merchant Identification.&lt;/p&gt;</value>
        public string ewicMerchantID { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the straddle subcategory identification.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the straddle subcategory identification.&lt;/p&gt;</value>
        public string straddleSubcategory { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the cash sign for CVB. The Cash Value Benefit (CVB) provides a cash amount of benefits instead of an UOM Code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the cash sign for CVB. The Cash Value Benefit (CVB) provides a cash amount of benefits instead of an UOM Code.&lt;/p&gt;</value>
        public string cvbUomCode { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether the confirm dialog to confirm the cancellation of the eWIC payment should be displayed or not.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether the confirm dialog to confirm the cancellation of the eWIC payment should be displayed or not.&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;values: true, false&lt;br /&gt;&lt;/pre&gt;</value>
        public bool? confirmCancelEwicPayment { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines the dialog for eWIC items limit exceeded action.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines the dialog for eWIC items limit exceeded action.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessUiMessageDialogConfig limitExceededConfirmDialogConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies the list of allowed tenders before eWIC payment. If there is not restriction for previous tender the value should be null.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies the list of allowed tenders before eWIC payment. If there is not restriction for previous tender the value should be null.&lt;/p&gt;</value>
        public List<string> PreviousTenderAllowed { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
