namespace POSGkSwaggerModel
{
    /// <summary>
    /// AllowedTendersConfig &lt;p&gt;This configuration entity defines the allowed tenders process.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsAllowedTendersConfig	{
        /// <summary>
        /// &lt;p&gt;Type of additional allowed tender validation to perform for returns.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type of additional allowed tender validation to perform for returns.&lt;/p&gt;</value>
        public returnTenderRuleEnum returnTenderRule { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the unique process ID.&lt;/p&gt;</value>
        public string processId { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines, whether the process should be treated as a main process or a shared helper process.&lt;br /&gt; This is relevant for context restriction checks, e.g. during barcode processing.&lt;br /&gt; Defaults to true. If false the related process will not be considered as main process.&lt;/p&gt;</value>
        public bool? mainProcess { get; init; }
        /// <summary>
        /// &lt;p&gt;This config defines authorization related processes.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This config defines authorization related processes.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessFlowsauthorizationConfig authorizationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter enables admissibility checks based on payin/payout reasons.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter enables admissibility checks based on payin/payout reasons.&lt;/p&gt;</value>
        public bool? checkReasonTender { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter enables admissibility checks based on a customer group assignment.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter enables admissibility checks based on a customer group assignment.&lt;/p&gt;</value>
        public bool? checkCustomerGroupTender { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter enables additional admissibility checks in case of a negative receipt total.&lt;br /&gt; @deprecated - since 5.9.2 this is not longer used.&lt;br /&gt; Use instead: returnTenderRule&lt;br /&gt; false -&amp;gt; RETURN_TO_ANY&lt;br /&gt; true -&amp;gt; RETURN_TO_ANY_MAPPED&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter enables additional admissibility checks in case of a negative receipt total.&lt;br /&gt; @deprecated - since 5.9.2 this is not longer used.&lt;br /&gt; Use instead: returnTenderRule&lt;br /&gt; false -&amp;gt; RETURN_TO_ANY&lt;br /&gt; true -&amp;gt; RETURN_TO_ANY_MAPPED&lt;/p&gt;</value>
        public bool? checkNegativeTotal { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter indicates whether tenders are used from the master data or taken from an existing collection for collection creation/updates.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter indicates whether tenders are used from the master data or taken from an existing collection for collection creation/updates.&lt;/p&gt;</value>
        public bool? useTenderFromMasterData { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines the tender filter rules chain (filters are executed in order).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines the tender filter rules chain (filters are executed in order).&lt;/p&gt;</value>
        public List<string> FilterRulesChain { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter specifies whether it is possible to override the admissibility of the selected tender for a customer temporary.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter specifies whether it is possible to override the admissibility of the selected tender for a customer temporary.&lt;/p&gt;</value>
        public bool? overrideAdmissibilityPossible { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
