namespace POSGkSwaggerModel
{
    /// <summary>
    /// AlternativeTaxInfos &lt;p&gt;This configuration entity defines the AlternativeTaxInfos.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsAlternativeTaxInfos	{
        /// <summary>
        /// &lt;p&gt;List of merchandise categories for which the alternative sales tax is to be used.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of merchandise categories for which the alternative sales tax is to be used.&lt;/p&gt;</value>
        public List<string> AlternativeTaxMerchandiseCategories { get; init; }
        /// <summary>
        /// &lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs separated by semicolon. The alternative tax will be applied to all line items with the merchandise hierarchy group defined in this list.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;If filled then the parameter alternativeTaxMerchandiseCategories will be ignored.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The parameter defines a list of merchandise hierarchy groups IDs separated by semicolon. The alternative tax will be applied to all line items with the merchandise hierarchy group defined in this list.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;If filled then the parameter alternativeTaxMerchandiseCategories will be ignored.&lt;/p&gt;</value>
        public string alternativeTaxMerchandiseCategoryList { get; init; }
        /// <summary>
        /// &lt;p&gt;Controls whether the merchandise category assignment is checked.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;True: Assignment to merchandise category defined in alternativeTaxMerchandiseCategoryList/alternativeTaxMerchandiseCategories is checked.&lt;br /&gt; False: Assignment to merchandise category defined in alternativeTaxMerchandiseCategoryList/alternativeTaxMerchandiseCategories is not checked.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Controls whether the merchandise category assignment is checked.&lt;/p&gt;&lt;br /&gt;&lt;p&gt;True: Assignment to merchandise category defined in alternativeTaxMerchandiseCategoryList/alternativeTaxMerchandiseCategories is checked.&lt;br /&gt; False: Assignment to merchandise category defined in alternativeTaxMerchandiseCategoryList/alternativeTaxMerchandiseCategories is not checked.&lt;/p&gt;</value>
        public bool? checkMerchandiseCategory { get; init; }
        /// <summary>
        /// &lt;p&gt;Alternative tax group&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Alternative tax group&lt;/p&gt;</value>
        public string alternativeTaxGroupId { get; init; }
        /// <summary>
        /// &lt;p&gt;false: The original tax group is used by default for each receipt. The toggle button is disabled.&lt;br /&gt; true: The alternative tax group is used by default for each receipt. The toggle button is enabled.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;false: The original tax group is used by default for each receipt. The toggle button is disabled.&lt;br /&gt; true: The alternative tax group is used by default for each receipt. The toggle button is enabled.&lt;/p&gt;</value>
        public bool? alternativeTaxMode { get; init; }
        /// <summary>
        /// &lt;p&gt;List of tax groups for which the alternative sales tax is not applied.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of tax groups for which the alternative sales tax is not applied.&lt;/p&gt;</value>
        public List<string> ExcludedTaxGroups { get; init; }
	}
}
