namespace POSGkSwaggerModel
{
    /// <summary>
    /// RegisterFuelLineItem &lt;p&gt;This entity defines fuel data from app enablement to be assigned to fuel sale return line item during item registration&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelConfigProcessFlowsRegisterFuelLineItem	{
        /// <summary>
        /// &lt;p&gt;Defines the Fueling Point Id (pump) where the transaction started&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the Fueling Point Id (pump) where the transaction started&lt;/p&gt;</value>
        public string fuelingPointId { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines grade Id of the fuel product&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines grade Id of the fuel product&lt;/p&gt;</value>
        public string gradeId { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines internal transaction number for the fuel services&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines internal transaction number for the fuel services&lt;/p&gt;</value>
        public int? stackPosition { get; init; }
        /// <summary>
        /// &lt;p&gt;This parameter defines fuel sale status code (transaction type).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;This parameter defines fuel sale status code (transaction type).&lt;/p&gt;</value>
        public string fuelSaleStatusCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the preset amount in case of prepay transactions&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the preset amount in case of prepay transactions&lt;/p&gt;</value>
        public double? presetAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the pos item id for the generic prepay item&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the pos item id for the generic prepay item&lt;/p&gt;</value>
        public string fuelPrepayItem { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the pos item UOM code for the generic prepay item&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the pos item UOM code for the generic prepay item&lt;/p&gt;</value>
        public string fuelPrepayItemUOMCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the actual amount for the fuel line item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the actual amount for the fuel line item.&lt;/p&gt;</value>
        public double? actualAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the discount for the fuel line item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the discount for the fuel line item.&lt;/p&gt;</value>
        public double? fuelDiscount { get; init; }
	}
}
