namespace POSGkSwaggerModel
{
    /// <summary>
    /// ItemInformation &lt;p&gt;Object to consolidate item information (e.g. master data, stock details, etc.).&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiModelDomAppItemInformationItemInformation	{
        /// <summary>
        /// &lt;p&gt;The business unit group ID&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The business unit group ID&lt;/p&gt;</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;The item ID&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The item ID&lt;/p&gt;</value>
        public string itemID { get; init; }
        /// <summary>
        /// &lt;p&gt;The unit of measure code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unit of measure code&lt;/p&gt;</value>
        public string uomCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The unit of measure name&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unit of measure name&lt;/p&gt;</value>
        public string uomName { get; init; }
        /// <summary>
        /// &lt;p&gt;Name of the item&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Name of the item&lt;/p&gt;</value>
        public string name { get; init; }
        /// <summary>
        /// &lt;p&gt;The main pos item id&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main pos item id&lt;/p&gt;</value>
        public string mainPOSItemId { get; init; }
        /// <summary>
        /// &lt;p&gt;Name of assigned merchandise hierarchy group.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Name of assigned merchandise hierarchy group.&lt;/p&gt;</value>
        public string merchandiseHierarchyGroupName { get; init; }
        /// <summary>
        /// &lt;p&gt;Amount of the actual price.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Amount of the actual price.&lt;/p&gt;</value>
        public double? validPriceAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;Amount of the regular price.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Amount of the regular price.&lt;/p&gt;</value>
        public double? regularPriceAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;Expiration (end) time stamp of the actual price.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Expiration (end) time stamp of the actual price.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string validPriceExpiryDate { get; init; }
        /// <summary>
        /// &lt;p&gt;Amount of the deposit&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Amount of the deposit&lt;/p&gt;</value>
        public double? deposit { get; init; }
        /// <summary>
        /// &lt;p&gt;Specifies the color of the item.&lt;br /&gt; Item characteristics entry with id COLOR is used to fill this value.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Specifies the color of the item.&lt;br /&gt; Item characteristics entry with id COLOR is used to fill this value.&lt;/p&gt;</value>
        public string color { get; init; }
        /// <summary>
        /// &lt;p&gt;Specifies the size, e.g. in case of fashion the dress size.&lt;br /&gt; Item characteristics entry with id SIZE is used to fill this value.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Specifies the size, e.g. in case of fashion the dress size.&lt;br /&gt; Item characteristics entry with id SIZE is used to fill this value.&lt;/p&gt;</value>
        public string size { get; init; }
        /// <summary>
        /// &lt;p&gt;Code of related tax group.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Code of related tax group.&lt;/p&gt;</value>
        public string taxGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;Item image url.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Item image url.&lt;/p&gt;</value>
        public string imageSrcIds { get; init; }
        /// <summary>
        /// &lt;p&gt;A flag to indicate that the retail store is authorized to stock this particular item.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A flag to indicate that the retail store is authorized to stock this particular item.&lt;/p&gt;</value>
        public bool? authorisedForSale { get; init; }
        /// <summary>
        /// &lt;p&gt;Stock details related to local store.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Stock details related to local store.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppItemInformationStockAmountDetail internalStock { get; init; }
        /// <summary>
        /// &lt;p&gt;List of stock details from surrounding stores.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of stock details from surrounding stores.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppItemInformationStockAmountDetail> ExternalStocks { get; init; }
        /// <summary>
        /// &lt;p&gt;The ItemInformationView instance.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The ItemInformationView instance.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppItemInformationItemInformationView itemView { get; init; }
        /// <summary>
        /// &lt;p&gt;It contains extended item information. The content is a filtered view on uom item text list. Filtering is done by text class ids defined in configuration.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It contains extended item information. The content is a filtered view on uom item text list. Filtering is done by text class ids defined in configuration.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppItemInformationUomItemText> UomItemTextList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of aviable price entries.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of aviable price entries.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppItemInformationPrice> Prices { get; init; }
        /// <summary>
        /// &lt;p&gt;It contains details about item info icons. The content is a filtered view on uom item text list. Filtering is done by text class ids defined in configuration.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It contains details about item info icons. The content is a filtered view on uom item text list. Filtering is done by text class ids defined in configuration.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiModelDomAppItemInformationUomItemText> ItemInfoIcons { get; init; }
        /// <summary>
        /// &lt;p&gt;It contains details about available promotions - e.g. Pay 2 get 3, 10% off...&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It contains details about available promotions - e.g. Pay 2 get 3, 10% off...&lt;/p&gt;</value>
        public List<comGkSoftwarePosFlowLibsTransactionDiscountIconList> DiscountInfoIcons { get; init; }
        /// <summary>
        /// &lt;p&gt;It contains item informations requested from web shop system.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It contains item informations requested from web shop system.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppItemInformationwebshopItemInfoData webshopItemInfoData { get; init; }
        /// <summary>
        /// &lt;p&gt;It contains info about variants available for this item&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It contains info about variants available for this item&lt;/p&gt;</value>
        public bool? variantsAvailable { get; init; }
        /// <summary>
        /// &lt;p&gt;Type code of the actual price (00 &#x3D; default price, 01 &#x3D; special price)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type code of the actual price (00 &#x3D; default price, 01 &#x3D; special price)&lt;/p&gt;</value>
        public string ePriceTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
