namespace POSGkSwaggerModel
{
    /// <summary>
    /// SalesOrderCreateConfirmationRequest &lt;p&gt;Request object for a sales order creation.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceCommunicationWsSalesOrderCreateRequestConfirmationEntitiesSalesOrderCreateConfirmationRequest	{
        /// <summary>
        /// &lt;p&gt;The store id.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The store id.&lt;/p&gt;</value>
        public string storeId { get; init; }
        /// <summary>
        /// &lt;p&gt;The date.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;The date.&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string date { get; init; }
        /// <summary>
        /// &lt;p&gt;The POS id.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The POS id.&lt;/p&gt;</value>
        public string posId { get; init; }
        /// <summary>
        /// &lt;p&gt;Sales order sequence number. This number is used for assembling a header uui for a sales order operation.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Sales order sequence number. This number is used for assembling a header uui for a sales order operation.&lt;/p&gt;</value>
        public int? sequenceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The delivery blocking reason code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The delivery blocking reason code.&lt;/p&gt;</value>
        public string deliveryBlockingReasonCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Processing type code of sales order based on delivery type.&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Pick up at another store: &#39;ZTA2&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Immediate pickup: &#39;SO&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Delivery from warehouse: &#39;TA&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Pickup from store: &#39;TA&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Processing type code of sales order based on delivery type.&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;Pick up at another store: &#39;ZTA2&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Immediate pickup: &#39;SO&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Delivery from warehouse: &#39;TA&#39;,&lt;/li&gt;&lt;br /&gt; &lt;li&gt;Pickup from store: &#39;TA&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string processingTypecode { get; init; }
        /// <summary>
        /// &lt;p&gt;Buyer document id (Token of length 1-35). Format: ffffddddddkkkbbbbbb&lt;br /&gt; ffff – store id with leading zeros&lt;br /&gt; dddddd – date in format ddmmyy (each with leading zeros)&lt;br /&gt; kkk – pos/workstation number with leading zeros&lt;br /&gt; bbbbbb – transaction sequence number with leading zeros&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Buyer document id (Token of length 1-35). Format: ffffddddddkkkbbbbbb&lt;br /&gt; ffff – store id with leading zeros&lt;br /&gt; dddddd – date in format ddmmyy (each with leading zeros)&lt;br /&gt; kkk – pos/workstation number with leading zeros&lt;br /&gt; bbbbbb – transaction sequence number with leading zeros&lt;/p&gt;</value>
        public string buyerDocumentId { get; init; }
        /// <summary>
        /// &lt;p&gt;Store number (Token of length 1-20).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Store number (Token of length 1-20).&lt;/p&gt;</value>
        public string salesOrganisationID { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines the code of the distribution channel in the SAP ERP system (Token of length 1-2). E.g.: &#39;V1&#39;.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines the code of the distribution channel in the SAP ERP system (Token of length 1-2). E.g.: &#39;V1&#39;.&lt;/p&gt;</value>
        public string distributionChannelCode { get; init; }
        /// <summary>
        /// &lt;p&gt;It defines the division/section in the SAP ERP system (Token of length 1-2). E.g.: &#39;R1&#39;.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;It defines the division/section in the SAP ERP system (Token of length 1-2). E.g.: &#39;R1&#39;.&lt;/p&gt;</value>
        public string divisionCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Customer number (Token of length 1-12).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customer number (Token of length 1-12).&lt;/p&gt;</value>
        public string buyerPartyInternalId { get; init; }
        /// <summary>
        /// &lt;p&gt;Customer order condition data.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customer order condition data.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceCommunicationWsSalesOrderCreateRequestConfirmationEntitiesCreateConfirmationRequestPriceComponent> PriceComponents { get; init; }
        /// <summary>
        /// &lt;p&gt;The item list.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The item list.&lt;/p&gt;</value>
        public List<comGkSoftwarePosApiServiceCommunicationWsSalesOrderCreateRequestConfirmationEntitiesCreateConfirmationRequestItem> Items { get; init; }
        /// <summary>
        /// &lt;p&gt;Indicates whether the service should be called in training mode.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Indicates whether the service should be called in training mode.&lt;/p&gt;</value>
        public bool? trainingMode { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
