namespace POSGkSwaggerModel
{
    /// <summary>
    /// TableStatus &lt;p&gt;Entity which represents the status of a table.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceHospitalityTableStatus	{
        /// <summary>
        /// &lt;p&gt;Status of the table&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Status of the table&lt;/p&gt;</value>
        public statusEnum? status { get; init; }
        /// <summary>
        /// &lt;p&gt;Number of the table (e.g. 10 or 10.1)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Number of the table (e.g. 10 or 10.1)&lt;/p&gt;</value>
        public string tableName { get; init; }
        /// <summary>
        /// &lt;p&gt;Current total of all open/unpaid line items of the table&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Current total of all open/unpaid line items of the table&lt;/p&gt;</value>
        public double? total { get; init; }
        /// <summary>
        /// &lt;p&gt;Workstation where the table is currently in progress. Only filled if Status &#x3D; InProgress&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Workstation where the table is currently in progress. Only filled if Status &#x3D; InProgress&lt;/p&gt;</value>
        public string currentWorkstationId { get; init; }
        /// <summary>
        /// &lt;p&gt;TransactionId of the last transaction of the table. The &#39;linked&#39; transaction contains all relevant data of the table&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;TransactionId of the last transaction of the table. The &#39;linked&#39; transaction contains all relevant data of the table&lt;/p&gt;</value>
        public string lastTransactionId { get; init; }
        /// <summary>
        /// &lt;p&gt;Transaction DO of the last transaction&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Transaction DO of the last transaction&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiTxpoolDtoTransaction lastTransaction { get; init; }
        /// <summary>
        /// &lt;p&gt;Workstation of the last modification&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Workstation of the last modification&lt;/p&gt;</value>
        public string lastWorkstationId { get; init; }
        /// <summary>
        /// &lt;p&gt;Id of the table owner (opened the table or handover)&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Id of the table owner (opened the table or handover)&lt;/p&gt;</value>
        public string tableOwnerId { get; init; }
        /// <summary>
        /// &lt;p&gt;First name of the table owner&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;First name of the table owner&lt;/p&gt;</value>
        public string tableOwnerFirstName { get; init; }
        /// <summary>
        /// &lt;p&gt;Last name of the table owner&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Last name of the table owner&lt;/p&gt;</value>
        public string tableOwnerLastName { get; init; }
        /// <summary>
        /// &lt;p&gt;Checksum of the transaction &lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Checksum of the transaction &lt;/p&gt;</value>
        public string checksum { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
