namespace POSGkSwaggerModel
{
    /// <summary>
    /// TerminalPaymentRequest &lt;p&gt;Request object used by terminal payment operations.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServicePaymentTerminalPaymentRequest	{
        /// <summary>
        /// &lt;p&gt;TerminalTransactionTypeCode: terminal transaction type code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;TerminalTransactionTypeCode: terminal transaction type code&lt;/p&gt;</value>
        public terminalTransactionTypeCodeEnum? terminalTransactionTypeCode { get; init; }
        /// <summary>
        /// Gets or Sets RequestType
        /// </summary>
        public requestTypeEnum? requestType { get; init; }
        /// <summary>
        /// &lt;p&gt;PositionOperationConfig: position operation config&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;PositionOperationConfig: position operation config&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessActionpositionOperationConfig positionOperationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;TenderDO: tender&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;TenderDO: tender&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiServerMdtenderDtoDomtenderDO tender { get; init; }
        /// <summary>
        /// &lt;p&gt;Amount: amount&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Amount: amount&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppamountamount amount { get; init; }
        /// <summary>
        /// &lt;p&gt;Amount: tip amount&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Amount: tip amount&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppAmountAmount tipAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;String: base iso currency code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String: base iso currency code&lt;/p&gt;</value>
        public string baseIsoCurrencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String: foreign iso currency code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String: foreign iso currency code&lt;/p&gt;</value>
        public string foreignIsoCurrencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;double: exchange rate&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;double: exchange rate&lt;/p&gt;</value>
        public double? exchangeRate { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean: multiply flag&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean: multiply flag&lt;/p&gt;</value>
        public bool? multiplyFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;String : tender class code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : tender class code&lt;/p&gt;</value>
        public string tenderClassCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : payment description&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : payment description&lt;/p&gt;</value>
        public string paymentDescription { get; init; }
        /// <summary>
        /// Gets or Sets KeyedOnline
        /// </summary>
        public bool? keyedOnline { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : success&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : success&lt;/p&gt;</value>
        public bool? success { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : auto cancellation&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : auto cancellation&lt;/p&gt;</value>
        public bool? autoCancellation { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : cancellation&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : cancellation&lt;/p&gt;</value>
        public bool? cancellation { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card type&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card type&lt;/p&gt;</value>
        public string cardType { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card issue code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card issue code&lt;/p&gt;</value>
        public string cardIssuerCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : account number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : account number&lt;/p&gt;</value>
        public string accountNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card entry method code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card entry method code&lt;/p&gt;</value>
        public string cardEntryMethodCode { get; init; }
        /// <summary>
        /// &lt;p&gt;double: cashbackAmount&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;double: cashbackAmount&lt;/p&gt;</value>
        public double? cashbackAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;String : entry source code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : entry source code&lt;/p&gt;</value>
        public string entrySourceCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : personal iD required type code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : personal iD required type code&lt;/p&gt;</value>
        public string personalIDRequiredTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;int : personal iD reference number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;int : personal iD reference number&lt;/p&gt;</value>
        public int? personalIDReferenceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : authorization method code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : authorization method code&lt;/p&gt;</value>
        public string authorizationMethodCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : adjudication code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : adjudication code&lt;/p&gt;</value>
        public string adjudicationCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card expiration date&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card expiration date&lt;/p&gt;</value>
        public string cardExpirationDate { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card holder name&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card holder name&lt;/p&gt;</value>
        public string cardHolderName { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card Issue sequence number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card Issue sequence number&lt;/p&gt;</value>
        public string cardIssueSequenceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card start date&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card start date&lt;/p&gt;</value>
        public string cardStartDate { get; init; }
        /// <summary>
        /// &lt;p&gt;String : service code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : service code&lt;/p&gt;</value>
        public string serviceCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : terminal transaction iD&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : terminal transaction iD&lt;/p&gt;</value>
        public string terminalTransactionID { get; init; }
        /// <summary>
        /// &lt;p&gt;String : terminal iD&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : terminal iD&lt;/p&gt;</value>
        public string terminalID { get; init; }
        /// <summary>
        /// &lt;p&gt;int : terminal transaction status&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;int : terminal transaction status&lt;/p&gt;</value>
        public int? terminalTransactionStatus { get; init; }
        /// <summary>
        /// &lt;p&gt;String : terminal transaction status&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : terminal transaction status&lt;/p&gt;</value>
        public string terminalTransactionResult { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card number&lt;/p&gt;</value>
        public string cardNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : merchant print cache&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : merchant print cache&lt;/p&gt;</value>
        public string merchantPrintCache { get; init; }
        /// <summary>
        /// &lt;p&gt;String : customer print cache&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : customer print cache&lt;/p&gt;</value>
        public string customerPrintCache { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : merchant cache printed&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : merchant cache printed&lt;/p&gt;</value>
        public bool? merchantCachePrinted { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : customer cache printed&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : customer cache printed&lt;/p&gt;</value>
        public bool? customerCachePrinted { get; init; }
        /// <summary>
        /// &lt;p&gt;String : approval code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : approval code&lt;/p&gt;</value>
        public string approvalCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : terminal type&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : terminal type&lt;/p&gt;</value>
        public string terminalType { get; init; }
        /// <summary>
        /// &lt;p&gt;String : merchant number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : merchant number&lt;/p&gt;</value>
        public string merchantNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : iso currency number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : iso currency number&lt;/p&gt;</value>
        public string isoCurrencyNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;Date : current date&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Date : current date&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string currentDate { get; init; }
        /// <summary>
        /// &lt;p&gt;int : transaction status&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;int : transaction status&lt;/p&gt;</value>
        public int? transactionStatus { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : force offline&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : force offline&lt;/p&gt;</value>
        public bool? forceOffline { get; init; }
        /// <summary>
        /// &lt;p&gt;String : card holder verification type code&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : card holder verification type code&lt;/p&gt;</value>
        public string cardHolderVerificationTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;boolean : host authorized flag&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;boolean : host authorized flag&lt;/p&gt;</value>
        public bool? hostAuthorizedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;int : trace number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;int : trace number&lt;/p&gt;</value>
        public int? traceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;int : terminal transaction error number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;int : terminal transaction error number&lt;/p&gt;</value>
        public int? terminalTransactionErrorNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : adjuction text&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : adjuction text&lt;/p&gt;</value>
        public string adjuctionText { get; init; }
        /// <summary>
        /// &lt;p&gt;TenderAuthorizationKey : current tender authorization key&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;TenderAuthorizationKey : current tender authorization key&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppServicesTransactionTenderAuthorizationKey currentTenderAuthorizationKey { get; init; }
        /// <summary>
        /// Gets or Sets RecoveryValues
        /// </summary>
        public ComGkSoftwarePosFlowLibsPaymentTerminalTransactionrecoveryValues recoveryValues { get; init; }
        /// <summary>
        /// Gets or Sets OrigTenderAuthorizationNumber
        /// </summary>
        public int? origTenderAuthorizationNumber { get; init; }
        /// <summary>
        /// Gets or Sets VoidingLineItemSequenceNumber
        /// </summary>
        public int? voidingLineItemSequenceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : terminal Reference Number&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : terminal Reference Number&lt;/p&gt;</value>
        public string terminalReferenceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;String : token that comes back from USA Payment servers.  Used with T+ &lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : token that comes back from USA Payment servers.  Used with T+ &lt;/p&gt;</value>
        public string token { get; init; }
        /// <summary>
        /// &lt;p&gt;String : format of the signature data ex. png, bmp &lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : format of the signature data ex. png, bmp &lt;/p&gt;</value>
        public string signatureFormat { get; init; }
        /// <summary>
        /// &lt;p&gt;String : signature data&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : signature data&lt;/p&gt;</value>
        public string signatureData { get; init; }
        /// <summary>
        /// Gets or Sets InternationalBankAccountNumber
        /// </summary>
        public string internationalBankAccountNumber { get; init; }
        /// <summary>
        /// Gets or Sets BankIdentifierCode
        /// </summary>
        public string bankIdentifierCode { get; init; }
        /// <summary>
        /// Gets or Sets CreditorID
        /// </summary>
        public string creditorID { get; init; }
        /// <summary>
        /// Gets or Sets MandateID
        /// </summary>
        public string mandateID { get; init; }
        /// <summary>
        /// Gets or Sets PrenotificationText
        /// </summary>
        public string prenotificationText { get; init; }
        /// <summary>
        /// &lt;p&gt;Tender description.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Tender description.&lt;/p&gt;</value>
        public string terminalTenderDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;Application identifier&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Application identifier&lt;/p&gt;</value>
        public string applicationID { get; init; }
        /// <summary>
        /// &lt;p&gt;Masked application PAN.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Masked application PAN.&lt;/p&gt;</value>
        public string encryptedPAN { get; init; }
        /// <summary>
        /// &lt;p&gt;Currency key (default 978).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Currency key (default 978).&lt;/p&gt;</value>
        public string terminalTransactionCurrencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;String : purchase restriction if any exists.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : purchase restriction if any exists.&lt;/p&gt;</value>
        public string purchaseRestriction { get; init; }
        /// <summary>
        /// &lt;p&gt;String : grade restriction value if any exists.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;String : grade restriction value if any exists.&lt;/p&gt;</value>
        public string gradeRestriction { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
