namespace POSGkSwaggerModel
{
    /// <summary>
    /// TakeOverSessionRequest &lt;p&gt;Request object for session take over during a service switch due to communication failure on other existing service instances.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceSmartposTakeOverSessionRequest	{
        /// <summary>
        /// &lt;p&gt;The operator login id.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The operator login id.&lt;/p&gt;</value>
        public string operatorId { get; init; }
        /// <summary>
        /// &lt;p&gt;The store identifier (business unit id).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The store identifier (business unit id).&lt;/p&gt;</value>
        public string retailStoreId { get; init; }
        /// <summary>
        /// &lt;p&gt;The workstation id.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The workstation id.&lt;/p&gt;</value>
        public string workstationId { get; init; }
        /// <summary>
        /// &lt;p&gt;The client application version.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The client application version.&lt;/p&gt;</value>
        public string clientVersion { get; init; }
        /// <summary>
        /// &lt;p&gt;The till identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The till identifier.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelDomAppServicesTransactionTillDoKey tillId { get; init; }
        /// <summary>
        /// &lt;p&gt;The main transaction currently in client transaction context.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The main transaction currently in client transaction context.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiTxpoolDtoTransaction mainTransaction { get; init; }
        /// <summary>
        /// &lt;p&gt;Scoped transactions currently present in client transaction context.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Scoped transactions currently present in client transaction context.&lt;/p&gt;</value>
        public Dictionary<string, ComGkSoftwareGkrApiTxpoolDtoTransaction> ScopedTransactions { get; init; }
        /// <summary>
        /// &lt;p&gt;The transaction id of the active transaction in client transaction context.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The transaction id of the active transaction in client transaction context.&lt;/p&gt;</value>
        public string activatedTransactionId { get; init; }
        /// <summary>
        /// &lt;p&gt;Complete last finalized transaction object.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Complete last finalized transaction object.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiTxpoolDtoTransaction lastFinalizedTransaction { get; init; }
        /// <summary>
        /// &lt;p&gt;Complete last finalized retail transaction object.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Complete last finalized retail transaction object.&lt;/p&gt;</value>
        public ComGkSoftwareGkrApiTxpoolDtoTransaction lastFinalizedRetailTransaction { get; init; }
        /// <summary>
        /// &lt;p&gt;The current pos session data in the client administration context.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The current pos session data in the client administration context.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiSessionposSessionData posSessionData { get; init; }
        /// <summary>
        /// &lt;p&gt;The current language settings in the client administration context.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The current language settings in the client administration context.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiServiceSessionlanguageSettings languageSettings { get; init; }
        /// <summary>
        /// &lt;p&gt;If true, the session take over will be enforced without further checks.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;If true, the session take over will be enforced without further checks.&lt;/p&gt;</value>
        public bool? enforceTakeOver { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
