namespace POSGkSwaggerModel
{
    /// <summary>
    /// CancelGiftCertTransactionRequest &lt;p&gt;Request object for canceling (voiding) a gift certificate.&lt;/p&gt;
    /// </summary>
    public record comGkSoftwarePosApiServiceStoredValueServerCancelGiftCertTransactionRequest	{
        /// <summary>
        /// &lt;p&gt;Specific id of gift certificate service to use.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Specific id of gift certificate service to use.&lt;/p&gt;</value>
        public string serviceId { get; init; }
        /// <summary>
        /// &lt;p&gt;Configuration for dealing with position operations when performing a gift certificate cancel.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Configuration for dealing with position operations when performing a gift certificate cancel.&lt;/p&gt;</value>
        public ComGkSoftwarePosApiModelConfigProcessActionpositionOperationConfig positionOperationConfig { get; init; }
        /// <summary>
        /// &lt;p&gt;Calling process identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Calling process identifier.&lt;/p&gt;</value>
        public string callingProcess { get; init; }
        /// <summary>
        /// &lt;p&gt;Stored values service identifier.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Stored values service identifier.&lt;/p&gt;</value>
        public string storedValuesServiceId { get; init; }
        /// <summary>
        /// &lt;p&gt;Transaction id for transaction containing the gift certificate to be canceled.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Transaction id for transaction containing the gift certificate to be canceled.&lt;/p&gt;</value>
        public string transactionId { get; init; }
        /// <summary>
        /// &lt;p&gt;Number of receipt of transaction canceling the gift certificate (transaction sequence number).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Number of receipt of transaction canceling the gift certificate (transaction sequence number).&lt;/p&gt;</value>
        public string receiptNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;Transaction ID of the transaction to be canceled at stored value server (eg.: top up transaction id).&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Transaction ID of the transaction to be canceled at stored value server (eg.: top up transaction id).&lt;/p&gt;</value>
        public string giftCertTransactionId { get; init; }
        /// <summary>
        /// &lt;p&gt;Gift certificate number.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Gift certificate number.&lt;/p&gt;</value>
        public string giftCertNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;Gift certificate track2 data.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Gift certificate track2 data.&lt;/p&gt;</value>
        public string track2 { get; init; }
        /// <summary>
        /// &lt;p&gt;Gift certificate amount.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Gift certificate amount.&lt;/p&gt;</value>
        public double? giftCertAmount { get; init; }
        /// <summary>
        /// &lt;p&gt;ISO currency code.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;ISO currency code.&lt;/p&gt;</value>
        public string isoCurrencyCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Approval code from terminal related to gift card transaction.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Approval code from terminal related to gift card transaction.&lt;/p&gt;</value>
        public string approvalCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The terminal reference number.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The terminal reference number.&lt;/p&gt;</value>
        public string terminalReferenceNumber { get; init; }
        /// <summary>
        /// &lt;p&gt;The original transaction UUID from registration. &lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The original transaction UUID from registration. &lt;/p&gt;</value>
        public string gcsTransactionUUID { get; init; }
        /// <summary>
        /// &lt;p&gt;Indicates whether failures should be ignored during the cancellation process and tries to cancel all gift certificates.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Indicates whether failures should be ignored during the cancellation process and tries to cancel all gift certificates.&lt;/p&gt;</value>
        public bool? ignoreFailures { get; init; }
        /// <summary>
        /// &lt;p&gt;Indicates whether tender line items should be voided during the cancellation process.&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Indicates whether tender line items should be voided during the cancellation process.&lt;/p&gt;</value>
        public bool? voidTenderLineItems { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Customizable information&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customizable information&lt;/p&gt;</value>
        public string xXCustom01 { get; init; }
	}
}
