namespace POSGkSwaggerModel
{
    /// <summary>
    /// PromotionConditionRuleSO &lt;p&gt;Promotion condition rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.Rule&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
    /// </summary>
    public record comGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditionRuleSO	{
        /// <summary>
        /// &lt;p&gt;This is a special code that determines when, during the entry of a sale transaction, this rule will be applied. For example a price change rule may be applied on a line item by line item basis (which is DETAIL TIME), a price change rule may be triggered after a transaction is totaled - - but before tax and tender entry (i.e. MERCHANDISE SUBTOTAL TIME).&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;line item discount, calculated after each line item („PO“)&lt;/li&gt;&lt;br /&gt; &lt;li&gt;line item discount, calculated after subtotal (“PC”)&lt;/li&gt;&lt;br /&gt; &lt;li&gt;transaction discount, calculated after each line item (“SP”)&lt;/li&gt;&lt;br /&gt; &lt;li&gt;transaction discount, calculated after subtotal („SU“)&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.Rule.GlobalData.TransactionControlCode&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.TransactionControlCode&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This is a special code that determines when, during the entry of a sale transaction, this rule will be applied. For example a price change rule may be applied on a line item by line item basis (which is DETAIL TIME), a price change rule may be triggered after a transaction is totaled - - but before tax and tender entry (i.e. MERCHANDISE SUBTOTAL TIME).&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;line item discount, calculated after each line item („PO“)&lt;/li&gt;&lt;br /&gt; &lt;li&gt;line item discount, calculated after subtotal (“PC”)&lt;/li&gt;&lt;br /&gt; &lt;li&gt;transaction discount, calculated after each line item (“SP”)&lt;/li&gt;&lt;br /&gt; &lt;li&gt;transaction discount, calculated after subtotal („SU“)&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.Rule.GlobalData.TransactionControlCode&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.TransactionControlCode&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public transactionControlBreakCodeEnum? transactionControlBreakCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the type of price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;RB &#x3D; simple rebate&lt;/li&gt;&lt;br /&gt; &lt;li&gt;MM &#x3D; Mix &amp;amp; Match&lt;/li&gt;&lt;br /&gt; &lt;li&gt;GP &#x3D; Get3Pay2&lt;/li&gt;&lt;br /&gt; &lt;li&gt;NO &#x3D; no rebate&lt;/li&gt;&lt;br /&gt; &lt;li&gt;MA &#x3D; manual, the discount information is set by POS function&lt;/li&gt;&lt;br /&gt; &lt;li&gt;EX &#x3D; external action&lt;/li&gt;&lt;br /&gt; &lt;li&gt;AP &#x3D; additional price type rule&lt;/li&gt;&lt;br /&gt; &lt;li&gt;AB &#x3D; additional bonus&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; The value is filled according to the used rule type from Promotion.Condition.Rule.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the type of price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;RB &#x3D; simple rebate&lt;/li&gt;&lt;br /&gt; &lt;li&gt;MM &#x3D; Mix &amp;amp; Match&lt;/li&gt;&lt;br /&gt; &lt;li&gt;GP &#x3D; Get3Pay2&lt;/li&gt;&lt;br /&gt; &lt;li&gt;NO &#x3D; no rebate&lt;/li&gt;&lt;br /&gt; &lt;li&gt;MA &#x3D; manual, the discount information is set by POS function&lt;/li&gt;&lt;br /&gt; &lt;li&gt;EX &#x3D; external action&lt;/li&gt;&lt;br /&gt; &lt;li&gt;AP &#x3D; additional price type rule&lt;/li&gt;&lt;br /&gt; &lt;li&gt;AB &#x3D; additional bonus&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; The value is filled according to the used rule type from Promotion.Condition.Rule.&lt;br /&gt;&lt;/p&gt;</value>
        public typeCodeEnum typeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines how the calculated reduction amount is to be rounded;&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null/00 &#x3D; commercial rounding&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; down&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02 &#x3D; up&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how the calculated reduction amount is to be rounded;&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null/00 &#x3D; commercial rounding&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; down&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02 &#x3D; up&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public roundingMethodCodeEnum? roundingMethodCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines, in which sequence items get rebate:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null &#x3D; determined by the corresponding property of the loyalty engine&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; lowest rebate first&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02 &#x3D; highest rebate first&lt;/li&gt;&lt;br /&gt; &lt;li&gt;03 &#x3D; lowest rebate first per interval&lt;/li&gt;&lt;br /&gt; &lt;li&gt;04 &#x3D; highest rebate first per interval&lt;/li&gt;&lt;br /&gt; &lt;li&gt;00 &#x3D; determined by the Promotion Calculation Engine&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.ChooseItemMethod&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines, in which sequence items get rebate:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null &#x3D; determined by the corresponding property of the loyalty engine&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; lowest rebate first&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02 &#x3D; highest rebate first&lt;/li&gt;&lt;br /&gt; &lt;li&gt;03 &#x3D; lowest rebate first per interval&lt;/li&gt;&lt;br /&gt; &lt;li&gt;04 &#x3D; highest rebate first per interval&lt;/li&gt;&lt;br /&gt; &lt;li&gt;00 &#x3D; determined by the Promotion Calculation Engine&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.ChooseItemMethod&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public chooseItemMethodEnum? chooseItemMethod { get; init; }
        /// <summary>
        /// &lt;p&gt;Base of the calculation:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: is determined by the eligibilities&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: sum of sales - sum of returns&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Base of the calculation:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: is determined by the eligibilities&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: sum of sales - sum of returns&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public calculationBaseEnum? calculationBase { get; init; }
        /// <summary>
        /// &lt;p&gt;Type code of the printout rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null/00 &#x3D; separate receipt&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; print at the end of the receipt&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon.CouponPrintoutRule&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type code of the printout rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null/00 &#x3D; separate receipt&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01 &#x3D; print at the end of the receipt&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon.CouponPrintoutRule&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public couponPrintoutRuleEnum? couponPrintoutRule { get; init; }
        /// <summary>
        /// &lt;p&gt;A identifier for a specific price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A identifier for a specific price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string internalRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;Price derivation rule name&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Price derivation rule name&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string name { get; init; }
        /// <summary>
        /// &lt;p&gt;Business description for this price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: from Promotion.Condition.Rule.GlobalData.RuleTranslationList or from Promotion.Condition.Rule.GlobalData.Description&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Business description for this price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: from Promotion.Condition.Rule.GlobalData.RuleTranslationList or from Promotion.Condition.Rule.GlobalData.Description&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string description { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the current status for the price derivation rule. Examples of valid codes include: Pending, Active, Canceled, Inactive&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;PD &#x3D; pending&lt;/li&gt;&lt;br /&gt; &lt;li&gt;AC/null &#x3D; active&lt;/li&gt;&lt;br /&gt; &lt;li&gt;CN &#x3D; cancelled&lt;/li&gt;&lt;br /&gt; &lt;li&gt;IA &#x3D; inactive&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: &#39;AC&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the current status for the price derivation rule. Examples of valid codes include: Pending, Active, Canceled, Inactive&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;PD &#x3D; pending&lt;/li&gt;&lt;br /&gt; &lt;li&gt;AC/null &#x3D; active&lt;/li&gt;&lt;br /&gt; &lt;li&gt;CN &#x3D; cancelled&lt;/li&gt;&lt;br /&gt; &lt;li&gt;IA &#x3D; inactive&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: &#39;AC&#39;&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string statusCode { get; init; }
        /// <summary>
        /// &lt;p&gt;External ident of the price derivation rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.ID&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;External ident of the price derivation rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.ID&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string ruleID { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether rebate or bonus points are awarded by the rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: true if Promotion.Condition.Rule.BonusPoints is chosen&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether rebate or bonus points are awarded by the rule&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: true if Promotion.Condition.Rule.BonusPoints is chosen&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? bonusPointsFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Requested number of decimal places of the calculated reduction amount;&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null &#x3D; 2 decimal places&lt;/li&gt;&lt;br /&gt; &lt;li&gt;value &#x3D; the calculated reduction amount is to be rounded/truncated because it should contain only the given number of decimal places&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Requested number of decimal places of the calculated reduction amount;&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null &#x3D; 2 decimal places&lt;/li&gt;&lt;br /&gt; &lt;li&gt;value &#x3D; the calculated reduction amount is to be rounded/truncated because it should contain only the given number of decimal places&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public int? decimalPlacesCount { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional information for rounding,&lt;br /&gt; possible values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null/1: no additional treatment of the rounded result necessary&lt;/li&gt;&lt;br /&gt; &lt;li&gt;5: the rounded result is to be adjusted to the next resp. previous multiple of 5&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional information for rounding,&lt;br /&gt; possible values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;null/1: no additional treatment of the rounded result necessary&lt;/li&gt;&lt;br /&gt; &lt;li&gt;5: the rounded result is to be adjusted to the next resp. previous multiple of 5&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public int? roundDestinationValue { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines how the rebate influences the transaction:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: the rebate reduces the transaction total&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: the rebate does not influence the transaction total or the amout the customer has to pay, but the customer gets a gift certificate about the rebate amount which he can use for payment the next time&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02: the rebate is used as tender for the current transaction, i.e. it reduces the amount the customer still has to pay&lt;/li&gt;&lt;br /&gt; &lt;li&gt;03: the rebate reduces the transaction total but it will be counterbalanced by some gift certificate sale.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;04: a coupon will be given to the customer instead of a rebate. Transaction total will not be reduced.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml:&lt;br /&gt;  &lt;ul&gt;&lt;br /&gt;   &lt;li&gt;00 - if Promotion.Condition.Rule.GlobalData.RebateMethod.NormalRebate is filled&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;01 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert is filled and Promotion.Condition.Rule.RebateMethod.RebateAsGiftCert.IsCharged &#x3D; false&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;02 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsTender is filled&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;03 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert is filled and Promotion.Condition.Rule.RebateMethod.RebateAsGiftCert.IsCharged &#x3D; true&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;04 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon is filled&lt;/li&gt;&lt;br /&gt;  &lt;/ul&gt;&lt;br /&gt; &lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how the rebate influences the transaction:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: the rebate reduces the transaction total&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: the rebate does not influence the transaction total or the amout the customer has to pay, but the customer gets a gift certificate about the rebate amount which he can use for payment the next time&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02: the rebate is used as tender for the current transaction, i.e. it reduces the amount the customer still has to pay&lt;/li&gt;&lt;br /&gt; &lt;li&gt;03: the rebate reduces the transaction total but it will be counterbalanced by some gift certificate sale.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;04: a coupon will be given to the customer instead of a rebate. Transaction total will not be reduced.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml:&lt;br /&gt;  &lt;ul&gt;&lt;br /&gt;   &lt;li&gt;00 - if Promotion.Condition.Rule.GlobalData.RebateMethod.NormalRebate is filled&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;01 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert is filled and Promotion.Condition.Rule.RebateMethod.RebateAsGiftCert.IsCharged &#x3D; false&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;02 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsTender is filled&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;03 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert is filled and Promotion.Condition.Rule.RebateMethod.RebateAsGiftCert.IsCharged &#x3D; true&lt;/li&gt;&lt;br /&gt;   &lt;li&gt;04 - if Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon is filled&lt;/li&gt;&lt;br /&gt;  &lt;/ul&gt;&lt;br /&gt; &lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string discountMethodCode { get; init; }
        /// <summary>
        /// &lt;p&gt;End of the date range in which the gift certificate is valid&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert.GiftCertExpiryDate&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;End of the date range in which the gift certificate is valid&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert.GiftCertExpiryDate&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string giftCertificateExpirationDate { get; init; }
        /// <summary>
        /// &lt;p&gt;A code which uniquely identifies the type of tender, ie cash, check, credit card, etc.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.RebateMethod.RebateAsTender.TenderTypeCode&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;A code which uniquely identifies the type of tender, ie cash, check, credit card, etc.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.RebateMethod.RebateAsTender.TenderTypeCode&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string tenderTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether applying this condition influences the calculation base of subsequent transaction-related conditionens (false) or not (true); is relevant for position-related &#39;money&#39; conditions only&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.ProhibitsBonRelatedConditionFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether applying this condition influences the calculation base of subsequent transaction-related conditionens (false) or not (true); is relevant for position-related &#39;money&#39; conditions only&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.ProhibitsBonRelatedConditionFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? prohibitTransactionRelatedPromotionConditionFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether applying this condition influences the calculation base of subsequent conditions (false) or not (true); is relevant for position-related &#39;money&#39; conditions only&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.NoInfluenceOnSubsequentConditionFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether applying this condition influences the calculation base of subsequent conditions (false) or not (true); is relevant for position-related &#39;money&#39; conditions only&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.NoInfluenceOnSubsequentConditionFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? noEffectOnSubsequentPromotionConditionFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;number of the printout coupon&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon.CouponPrintoutID&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;number of the printout coupon&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon.CouponPrintoutID&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string couponPrintoutID { get; init; }
        /// <summary>
        /// &lt;p&gt;Formated Text of the printout coupon&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon.CouponPrintoutText&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Formated Text of the printout coupon&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsCoupon.CouponPrintoutText&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public Object couponPrintoutText { get; init; }
        /// <summary>
        /// &lt;p&gt;Indicates whether all conditions are to be considered which were applied before (true) or not (false).&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.ConsiderAllPreviousConditionsFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Indicates whether all conditions are to be considered which were applied before (true) or not (false).&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.ConsiderAllPreviousConditionsFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? considerPreviousPromotionConditionFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Validity period for printout coupons or gift certificates&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert.PrintoutValidityPeriod or Promotion.Condition.Rule.RebateMethod.RebateAsCoupon.PrintoutValidityPeriod&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Validity period for printout coupons or gift certificates&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Not imported.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.Rule.GlobalData.RebateMethod.RebateAsGiftCert.PrintoutValidityPeriod or Promotion.Condition.Rule.RebateMethod.RebateAsCoupon.PrintoutValidityPeriod&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public double? printoutValidityPeriod { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string tid { get; init; }
        /// <summary>
        /// &lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditionRuleTranslationSO> PromotionConditionRuleTranslationList { get; init; }
        /// <summary>
        /// &lt;p&gt;External ID of the condition rule (filled with PromotionConditionID)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;External ID of the condition rule (filled with PromotionConditionID)&lt;br /&gt;&lt;/p&gt;</value>
        public string externalConditionRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines which one of the previously applied modifiers is to be considered as calculation base for the current modification. In detail, the calculation base for the current price derivation rule is to be determined as following:&lt;br /&gt; - In case that no price derivation rules were applied before, it is the original price/total.&lt;br /&gt; - Null: all price derivation rules which were applied before the current price derivation rule are to be considered, i.e. the calculation base for the current price derivation rule equals to the new price of the price derivation rule which was applied just before it &#x3D; as latest.&lt;br /&gt; - Otherwise, the calculation base for the current price derivation rule equals to the new price of that price derivation rule which was applied one or more steps before it having the highest sequence &amp;lt;&#x3D; CalculationBaseSequence (or the original price if no such price derivation rule was applied).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines which one of the previously applied modifiers is to be considered as calculation base for the current modification. In detail, the calculation base for the current price derivation rule is to be determined as following:&lt;br /&gt; - In case that no price derivation rules were applied before, it is the original price/total.&lt;br /&gt; - Null: all price derivation rules which were applied before the current price derivation rule are to be considered, i.e. the calculation base for the current price derivation rule equals to the new price of the price derivation rule which was applied just before it &#x3D; as latest.&lt;br /&gt; - Otherwise, the calculation base for the current price derivation rule equals to the new price of that price derivation rule which was applied one or more steps before it having the highest sequence &amp;lt;&#x3D; CalculationBaseSequence (or the original price if no such price derivation rule was applied).&lt;br /&gt;&lt;/p&gt;</value>
        public string calculationBaseSequence { get; init; }
        /// <summary>
        /// &lt;p&gt;The system-generated identifier of the rounding rule which applies for discounts/bonus points counts resulting from applying the price derivation rule&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The system-generated identifier of the rounding rule which applies for discounts/bonus points counts resulting from applying the price derivation rule&lt;br /&gt;&lt;/p&gt;</value>
        public string roundingRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;The system-generated identifier of the rounding rule which applies for shares resulting from prorating basket-related discounts or bonus points resulting from applying the price derivation rule&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The system-generated identifier of the rounding rule which applies for shares resulting from prorating basket-related discounts or bonus points resulting from applying the price derivation rule&lt;br /&gt;&lt;/p&gt;</value>
        public string shareRoundingRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;The system-generated identifier of the rounding rule applies for monetary equivalents to bonus points counts resulting from applying the price derivation rule&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The system-generated identifier of the rounding rule applies for monetary equivalents to bonus points counts resulting from applying the price derivation rule&lt;br /&gt;&lt;/p&gt;</value>
        public string pointsAmountRoundingRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the price derivation rule is applicable in general (false) or only in the case that no other monetary discounts were granted before (true).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the price derivation rule is applicable in general (false) or only in the case that no other monetary discounts were granted before (true).&lt;br /&gt;&lt;/p&gt;</value>
        public bool? noPreviousMonetaryDiscountAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;This flag decides whether a promotion price derivation rule or a particular price is allowed to increase the price in comparison to the latest calculated discount sales price.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Possible values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;true: price increase is allowed. In this case, the promotion price derivation rule is applied even though the item costs afterwards more than before.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;false: price increase is not allowed. In this case, the promotion price derivation rule is not applied without any thrown business error or indicator why.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;This flag decides whether a promotion price derivation rule or a particular price is allowed to increase the price in comparison to the latest calculated discount sales price.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Possible values:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;true: price increase is allowed. In this case, the promotion price derivation rule is applied even though the item costs afterwards more than before.&lt;/li&gt;&lt;br /&gt; &lt;li&gt;false: price increase is not allowed. In this case, the promotion price derivation rule is not applied without any thrown business error or indicator why.&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? increasePriceAllowedFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;For measured items (e.g. pre-packed weighed items), the package limit quantity limits the maximum package count that can receive a benefit. A price derivation rule containing a package limit quantity being not null and greater than zero can be applied to measured items only, but not to piece items.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;For measured items (e.g. pre-packed weighed items), the package limit quantity limits the maximum package count that can receive a benefit. A price derivation rule containing a package limit quantity being not null and greater than zero can be applied to measured items only, but not to piece items.&lt;br /&gt;&lt;/p&gt;</value>
        public int? packageLimitQuantity { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom17 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom30 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom01 { get; init; }
	}
}
