namespace POSGkSwaggerModel
{
    /// <summary>
    /// PromotionConditionSO &lt;p&gt;Condition of the promotion&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
    /// </summary>
    public record comGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditionSO	{
        /// <summary>
        /// &lt;p&gt;Determines whether the condition can be used only for sales, only for returns, or for both:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: for sales as well as for returns&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: only for sales&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02: only for returns&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the condition can be used only for sales, only for returns, or for both:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: for sales as well as for returns&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: only for sales&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02: only for returns&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public saleReturnTypeCodeEnum? saleReturnTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the condition can be used only for sales, only for amendments, or for both:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: for sales as well as for amendments&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: only for sales&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02: only for amendments&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the condition can be used only for sales, only for amendments, or for both:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;00/null: for sales as well as for amendments&lt;/li&gt;&lt;br /&gt; &lt;li&gt;01: only for sales&lt;/li&gt;&lt;br /&gt; &lt;li&gt;02: only for amendments&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public amendmentTypeCodeEnum? amendmentTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;The unique identifier for a promotion.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Mapped from promotion.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier for a promotion.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Mapped from promotion.&lt;br /&gt;&lt;/p&gt;</value>
        public string promotionID { get; init; }
        /// <summary>
        /// &lt;p&gt;A identifier for a condition.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generared, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A identifier for a condition.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generared, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string conditionID { get; init; }
        /// <summary>
        /// &lt;p&gt;A identifier for a specific price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A identifier for a specific price derivation rule.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string internalRuleID { get; init; }
        /// <summary>
        /// &lt;p&gt;A unique identifier for a Price Derivation Rule eligibility. It is the ID of the root eligibility of the condition. (useful if the combination eligibility is used).&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A unique identifier for a Price Derivation Rule eligibility. It is the ID of the root eligibility of the condition. (useful if the combination eligibility is used).&lt;br /&gt;&lt;/p&gt;</value>
        public string internalEligibilityID { get; init; }
        /// <summary>
        /// &lt;p&gt;Time restrictions&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.GlobalData.TimePeriod&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.TimePeriod&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;Time restrictions&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.GlobalData.TimePeriod&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.TimePeriod&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public ComGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditiontimeGroupSO timeGroup { get; init; }
        /// <summary>
        /// &lt;p&gt;Code of the condition type&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Code of the condition type&lt;br /&gt;&lt;/p&gt;</value>
        public string typeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Rule data&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Rule data&lt;br /&gt;&lt;/p&gt;</value>
        public ComGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditionruleSO rule { get; init; }
        /// <summary>
        /// &lt;p&gt;Eligibility data (tree)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Eligibility data (tree)&lt;br /&gt;&lt;/p&gt;</value>
        public ComGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditioneligibilitySO eligibility { get; init; }
        /// <summary>
        /// &lt;p&gt;Sequence - for collision handling&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Sequence - for collision handling&lt;br /&gt;&lt;/p&gt;</value>
        public string sequence { get; init; }
        /// <summary>
        /// &lt;p&gt;Resolution - for collision handling&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Resolution - for collision handling&lt;br /&gt;&lt;/p&gt;</value>
        public string resolution { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines whether the result of the applied condition is to be suppressed on displays / not printed on the receipt; e.g. position-dependent default points are not printed after each position, but only summarized at the end of the receipt.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines whether the result of the applied condition is to be suppressed on displays / not printed on the receipt; e.g. position-dependent default points are not printed after each position, but only summarized at the end of the receipt.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? notShowingFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Short description&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Short description&lt;br /&gt;&lt;/p&gt;</value>
        public string description { get; init; }
        /// <summary>
        /// &lt;p&gt;Receipt text (overwrites the receipt text of the promotion)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Receipt text (overwrites the receipt text of the promotion)&lt;br /&gt;&lt;/p&gt;</value>
        public string receiptPrinterName { get; init; }
        /// <summary>
        /// &lt;p&gt;Operator display text (overwrites the operator display text of the promotion)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Operator display text (overwrites the operator display text of the promotion)&lt;br /&gt;&lt;/p&gt;</value>
        public string operatorDisplayName { get; init; }
        /// <summary>
        /// &lt;p&gt;Customer display text (overwrites the customer display text of the promotion)&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Customer display text (overwrites the customer display text of the promotion)&lt;br /&gt;&lt;/p&gt;</value>
        public string customerDisplayName { get; init; }
        /// <summary>
        /// &lt;p&gt;&#39;vector&#39; which describes which discount typecodes are allowed for usage by the loyalty server; Item.DiscountTypeCode is used as an index in order to find the right position inside the vector;&lt;br /&gt; Possible values for each position are:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;0 - -&gt; no discount possible&lt;/li&gt;&lt;br /&gt; &lt;li&gt;1 - -&gt; discount possible&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;&#39;vector&#39; which describes which discount typecodes are allowed for usage by the loyalty server; Item.DiscountTypeCode is used as an index in order to find the right position inside the vector;&lt;br /&gt; Possible values for each position are:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;0 - -&gt; no discount possible&lt;/li&gt;&lt;br /&gt; &lt;li&gt;1 - -&gt; discount possible&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string itemDiscountControlVector { get; init; }
        /// <summary>
        /// &lt;p&gt;determines whether this condition is an exclusive condition&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.GlobalData.ExclusivenessFlag&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.ExclusivenessFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;determines whether this condition is an exclusive condition&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;masterdata_Promotion_SE.xml: Promotion.Condition.GlobalData.ExclusivenessFlag&lt;/li&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.ExclusivenessFlag&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public bool? exclusiveFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;ID of the icon that should be displayed as sales information on POS&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.IconID&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;
        /// </summary>
        /// <value>&lt;p&gt;ID of the icon that should be displayed as sales information on POS&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;ul&gt;&lt;br /&gt; &lt;li&gt;PromotionCPD.xml: Promotion.Condition.GlobalData.IconID&lt;/li&gt;&lt;br /&gt;&lt;/ul&gt;</value>
        public string iconID { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines how this condition works in relation to other applicable conditions&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines how this condition works in relation to other applicable conditions&lt;br /&gt;&lt;/p&gt;</value>
        public string concurrenceControlVector { get; init; }
        /// <summary>
        /// &lt;p&gt;Describes whether the promotion is prohibited/cannot be applied in line item mode.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Describes whether the promotion is prohibited/cannot be applied in line item mode.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? notConsideredInLineItemModeFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines what percentage of the triggers of the recommended promotion have to be reached by the items in the transaction in order for the PCE to make the recommendation.&lt;br /&gt; The supported types of leaf eligibilities which are considered when evaluating the threshold percentage are: ITEM, MSET, MSTR, SITH, TOTL.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines what percentage of the triggers of the recommended promotion have to be reached by the items in the transaction in order for the PCE to make the recommendation.&lt;br /&gt; The supported types of leaf eligibilities which are considered when evaluating the threshold percentage are: ITEM, MSET, MSTR, SITH, TOTL.&lt;br /&gt;&lt;/p&gt;</value>
        public int? recommendationThresholdPercentage { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the list of recommendation contexts in which the promotion can be recommended by the PCE.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the list of recommendation contexts in which the promotion can be recommended by the PCE.&lt;br /&gt;&lt;/p&gt;</value>
        public List<string> RecommendationContextList { get; init; }
        /// <summary>
        /// &lt;p&gt;Flag indicating if the promotion price derivation rule is available for recommendations or not.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Flag indicating if the promotion price derivation rule is available for recommendations or not.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? recommendationFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string tid { get; init; }
        /// <summary>
        /// &lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdPromotionDtoSoPromotionConditionTranslationSO> PromotionConditionTranslationList { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom17 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom30 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterdata_Promotion_SE.xml only.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom01 { get; init; }
	}
}
