namespace POSGkSwaggerModel
{
    /// <summary>
    /// ReasonSO &lt;p&gt;Reasons are used for sale and merchandise management processes. They are used to designate different goods movements. Reasons may contain a number of parameters. Each parameter has a defined name with a certain meaning for the respective process.&lt;br /&gt; Reasons are grouped by processes. Each reason is identified based on a combination of code + group.&lt;br /&gt; Each group has a fixed code. The reasons belonging to this group are used in the respective process.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import from masterData_Reason.xml.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareSweeSesApiServerMdReasonDtoSoReasonSO	{
        /// <summary>
        /// &lt;p&gt;Type of origin.&lt;br /&gt; OriginCode:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt; PARENT_COPY &#x3D; &#39;00&#39;&lt;br /&gt; IMPORT &#x3D; &#39;01&#39;&lt;br /&gt; MANUAL &#x3D; &#39;02&#39;&lt;br /&gt;&lt;/pre&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type of origin.&lt;br /&gt; OriginCode:&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt; PARENT_COPY &#x3D; &#39;00&#39;&lt;br /&gt; IMPORT &#x3D; &#39;01&#39;&lt;br /&gt; MANUAL &#x3D; &#39;02&#39;&lt;br /&gt;&lt;/pre&gt;</value>
        public originEnum? origin { get; init; }
        /// <summary>
        /// &lt;p&gt;The unique identifier of the business unit group.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Reason.xml: BusinessUnitGroupID or the BusinessUnitGroupID for the ExternalBusinessUnitGroupID from Reason.BugHeader or if not filled, then from ReasonMasterData.BugHeader. If not filled, then the reason is globally valid.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The unique identifier of the business unit group.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Reason.xml: BusinessUnitGroupID or the BusinessUnitGroupID for the ExternalBusinessUnitGroupID from Reason.BugHeader or if not filled, then from ReasonMasterData.BugHeader. If not filled, then the reason is globally valid.&lt;br /&gt;&lt;/p&gt;</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;Long description of the reason&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Long description of the reason&lt;br /&gt;&lt;/p&gt;</value>
        public string reasonDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;Reason short text&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Reason short text&lt;br /&gt;&lt;/p&gt;</value>
        public string reasonShortText { get; init; }
        /// <summary>
        /// &lt;p&gt;Code of the group to which the reason belongs&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Code of the group to which the reason belongs&lt;br /&gt;&lt;/p&gt;</value>
        public string reasonCodeGroupCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Description of the assigned reason group; for information purposes&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Not imported, loaded from ReasonCodeGroupSO.reasonCodeGroupDescription&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Description of the assigned reason group; for information purposes&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Not imported, loaded from ReasonCodeGroupSO.reasonCodeGroupDescription&lt;br /&gt;&lt;/p&gt;</value>
        public string reasonCodeGroupDescription { get; init; }
        /// <summary>
        /// &lt;p&gt;Defines the order within a group for display in the graphical user interface&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Defines the order within a group for display in the graphical user interface&lt;br /&gt;&lt;/p&gt;</value>
        public int? reasonOrder { get; init; }
        /// <summary>
        /// &lt;p&gt;List of reason parameters&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of reason parameters&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdReasonDtoSoReasonParameterSO> ReasonParameterList { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation identifier&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation identifier&lt;br /&gt;&lt;/p&gt;</value>
        public string tid { get; init; }
        /// <summary>
        /// &lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdReasonDtoSoReasonTranslationSO> Translations { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom01 { get; init; }
        /// <summary>
        /// &lt;p&gt;A unique retailer defined reason code for an action that is taken (or not taken) at a workstation / device.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A unique retailer defined reason code for an action that is taken (or not taken) at a workstation / device.&lt;br /&gt;&lt;/p&gt;</value>
        public string reasonCode { get; init; }
	}
}
