namespace POSGkSwaggerModel
{
    /// <summary>
    /// SalesRestrictionSO &lt;p&gt;Specific items can be sold under defined conditions only, e.g. alcohol drinks from 18 years. Sales restrictions determine these conditions.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestrictionList&lt;br /&gt; masterData_BusinessUnit.xml: BusinessUnit.MerchandiseHierarchyGroupDetail.RiskSaleResctriction.&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareSweeSesApiServerMdSalesRestrictionDtoSoSalesRestrictionSO	{
        /// <summary>
        /// &lt;p&gt;Sales restriction identifier&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Sales restriction identifier&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string salesRestrictionID { get; init; }
        /// <summary>
        /// &lt;p&gt;A unique system assigned identifier for a group of business units.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;A unique system assigned identifier for a group of business units.&lt;br /&gt;&lt;/p&gt;</value>
        public string businessUnitGroupID { get; init; }
        /// <summary>
        /// &lt;p&gt;The value of the sales restriction - its content depends on the SalesRestrictionTypeCode, e.g.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * Age &#x3D;&amp;gt; minimum customer age&lt;br /&gt;    * Sales prohibition period &#x3D;&amp;gt; time group identifier&lt;br /&gt;    * Limit &#x3D;&amp;gt; quantity limit&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.SalesRestrictionValue&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The value of the sales restriction - its content depends on the SalesRestrictionTypeCode, e.g.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * Age &#x3D;&amp;gt; minimum customer age&lt;br /&gt;    * Sales prohibition period &#x3D;&amp;gt; time group identifier&lt;br /&gt;    * Limit &#x3D;&amp;gt; quantity limit&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.SalesRestrictionValue&lt;br /&gt;&lt;/p&gt;</value>
        public string salesRestrictionValue { get; init; }
        /// <summary>
        /// &lt;p&gt;List of merchandise hierarchy groups which the sales restriction is assigned to&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_BusinessUnit.xml: BusinessUnit.MerchandiseHierarchyGroupDetail.MerchandiseHierarchyGroupID.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of merchandise hierarchy groups which the sales restriction is assigned to&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_BusinessUnit.xml: BusinessUnit.MerchandiseHierarchyGroupDetail.MerchandiseHierarchyGroupID.&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdSalesRestrictionDtoSoMerchandiseHierarchyGroupAssignmentSO> MerchandiseHierarchyGroupAssignmentList { get; init; }
        /// <summary>
        /// &lt;p&gt;List of UOM items which the sales restriction is assigned to&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item identification.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of UOM items which the sales restriction is assigned to&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item identification.&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdSalesRestrictionDtoSoUnitOfMeasureItemAssignmentSO> UnitOfMeasureItemAssignmentList { get; init; }
        /// <summary>
        /// &lt;p&gt;The text of the question that the customer is to be asked when validating a restriction.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.QuestionText&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;The text of the question that the customer is to be asked when validating a restriction.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.QuestionText&lt;br /&gt;&lt;/p&gt;</value>
        public string questionText { get; init; }
        /// <summary>
        /// &lt;p&gt;Type code of the question.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.QuestionTypeCode&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Type code of the question.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.QuestionTypeCode&lt;br /&gt;&lt;/p&gt;</value>
        public string questionTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Translation identifier - used for the unique identification of translations in the common translation table.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Generated, not imported.&lt;br /&gt;&lt;/p&gt;</value>
        public string tid { get; init; }
        /// <summary>
        /// &lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.TranslationList&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;List of translations&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.TranslationList&lt;br /&gt;&lt;/p&gt;</value>
        public List<comGkSoftwareSweeSesApiServerMdSalesRestrictionDtoSoSalesRestrictionTranslationSO> TranslationList { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM18 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM19 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM20 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM21 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM22 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM23 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM24 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM25 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM26 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM27 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM28 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM29 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM30 { get; init; }
        /// <summary>
        /// &lt;p&gt;Sales restriction type code, e.g.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * AGE, CAGE &#x3D;&amp;gt; Age (customer age is to be checked)&lt;br /&gt;    * TIME &#x3D;&amp;gt; Sales prohibition period (sale is prohibited during specified time)&lt;br /&gt;    * LIMT &#x3D;&amp;gt; Limit (maximally this quantity of the item may be sold)&lt;br /&gt;    * WGHT &#x3D;&amp;gt; Weight (the weight is to be checked)&lt;br /&gt;    * RISK &#x3D;&amp;gt; Risk (the sale of that item is to be double-checked)&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.SalesRestrictionTypeCode&lt;br /&gt; masterData_BusinessUnit.xml: &#39;RISK&#39; for BusinessUnit.MerchandiseHierarchyGroupDetail.RiskSaleResctriction&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Sales restriction type code, e.g.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;pre&gt;    * AGE, CAGE &#x3D;&amp;gt; Age (customer age is to be checked)&lt;br /&gt;    * TIME &#x3D;&amp;gt; Sales prohibition period (sale is prohibited during specified time)&lt;br /&gt;    * LIMT &#x3D;&amp;gt; Limit (maximally this quantity of the item may be sold)&lt;br /&gt;    * WGHT &#x3D;&amp;gt; Weight (the weight is to be checked)&lt;br /&gt;    * RISK &#x3D;&amp;gt; Risk (the sale of that item is to be double-checked)&lt;br /&gt;&lt;/pre&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; masterData_Item.xml: Item.UOMItem.SalesRestriction.SalesRestrictionTypeCode&lt;br /&gt; masterData_BusinessUnit.xml: &#39;RISK&#39; for BusinessUnit.MerchandiseHierarchyGroupDetail.RiskSaleResctriction&lt;br /&gt;&lt;/p&gt;</value>
        public string salesRestrictionTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM01 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM06 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM07 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM08 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM09 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM10 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM11 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM12 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM13 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM14 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM15 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM16 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxCUSTOM17 { get; init; }
	}
}
