namespace POSGkSwaggerModel
{
    /// <summary>
    /// PeripheralAccessSO &lt;p&gt;Login data of one specific periphery class in the specific retail store&lt;br /&gt;&lt;/p&gt;
    /// </summary>
    public record comGkSoftwareSweeSesApiServerUmOperatorDtoSoPeripheralAccessSO	{
        /// <summary>
        /// &lt;p&gt;Retail store ID of the periphery access assignment&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: from Operator.BusinessUnitAssignment.BusinessUnitIdentification: BusinessUnitID or the corresponding retail store ID for the ExternalBusinessUnitID&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Retail store ID of the periphery access assignment&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: from Operator.BusinessUnitAssignment.BusinessUnitIdentification: BusinessUnitID or the corresponding retail store ID for the ExternalBusinessUnitID&lt;br /&gt;&lt;/p&gt;</value>
        public string retailStoreID { get; init; }
        /// <summary>
        /// &lt;p&gt;Identification of the periphery class. Possible values: &#39;Mobile&#39;, &#39;Web&#39;, &#39;POS&#39;, &#39;SCALE&#39;, &#39;RVM&#39;, &#39;ESL&#39; etc.&lt;br /&gt; This attribute allows to define different login data for different peripheral systems.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.PeripheralSystemType&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Identification of the periphery class. Possible values: &#39;Mobile&#39;, &#39;Web&#39;, &#39;POS&#39;, &#39;SCALE&#39;, &#39;RVM&#39;, &#39;ESL&#39; etc.&lt;br /&gt; This attribute allows to define different login data for different peripheral systems.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.PeripheralSystemType&lt;br /&gt;&lt;/p&gt;</value>
        public string peripheralsTypeCode { get; init; }
        /// <summary>
        /// &lt;p&gt;Login name. The login name for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.LoginName&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Login name. The login name for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.LoginName&lt;br /&gt;&lt;/p&gt;</value>
        public string loginName { get; init; }
        /// <summary>
        /// &lt;p&gt;Password. The password for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.Password&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Password. The password for the target systems POS, Scale and Mobile can be numeric only.&lt;br /&gt;&lt;/p&gt;&lt;br /&gt;&lt;p&gt;Import:&lt;br /&gt; Operator.xml: Operator.BusinessUnitAssignment.BusinessUnitAssignmentContent.PeripheralSystemTypeLogin.Password&lt;br /&gt;&lt;/p&gt;</value>
        public string loginPassword { get; init; }
        /// <summary>
        /// &lt;p&gt;Timestamp (date and time), when the password was created.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Timestamp (date and time), when the password was created.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string passwordCreateTimestamp { get; init; }
        /// <summary>
        /// &lt;p&gt;Count of failed log in attempts. This value is reset after a successfully log in.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Count of failed log in attempts. This value is reset after a successfully log in.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;</value>
        public int? passwordFailedAttemptsCount { get; init; }
        /// <summary>
        /// &lt;p&gt;Timestamp of last successfully log in&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)
        /// </summary>
        /// <value>&lt;p&gt;Timestamp of last successfully log in&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt; Date format &#39;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSS&#39; (no timezone)</value>
        public string passwordLastSuccessfulLoginTimestamp { get; init; }
        /// <summary>
        /// &lt;p&gt;Determines, if the access is blocked.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Determines, if the access is blocked.&lt;br /&gt; FAT POS will save these attributes locally. They will be never known on the central.&lt;br /&gt;&lt;/p&gt;</value>
        public bool? accessBlockingFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Initial password flag&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Initial password flag&lt;br /&gt;&lt;/p&gt;</value>
        public bool? initialPasswordFlag { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom05 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom03 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom02 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom04 { get; init; }
        /// <summary>
        /// &lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;
        /// </summary>
        /// <value>&lt;p&gt;Additional field for custom development.&lt;br /&gt;&lt;/p&gt;</value>
        public string xxcustom01 { get; init; }
	}
}
