﻿using app_datafono_difare.Services;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare.Controllers
{
    [ApiController]
    [Route("api/pinpad")]
    public class PinpadController : ControllerBase
    {
        private readonly PinpadInitializer _init;
        private readonly PinpadRestService _service;

        public PinpadController(PinpadInitializer init, PinpadRestService service)
        {
            _init = init;
            _service = service;
        }

        [HttpPost("init")]
        public IActionResult Inicializar([FromBody] InitPinpadRequest req)
        {
            _init.Inicializar(req.Url, req.Estacion);
            return Ok(new { message = "Pinpad inicializado" });
        }

        [HttpPost("venta")]
        public async Task<IActionResult> Venta([FromBody] VentaRequest req)
        {
            var resp = await _service.AutorizarAsync(req.Amount, req.Cuotas);
            return Ok(resp);
        }
    }

    public class InitPinpadRequest
    {
        public string Url { get; set; }
        public string Estacion { get; set; }
    }

    public class VentaRequest
    {
        public decimal Amount { get; set; }
        public int Cuotas { get; set; }
    }
}
