﻿using Microsoft.Owin.Hosting;
using Serilog;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare.Services
{
    public class PinpadService
    {
        private IDisposable _webApp;

        public void Start()
        {
            Log.Information("Iniciando servicio OWIN...");

            string baseUrl = System.Configuration.ConfigurationManager.AppSettings["BaseUrl"];

            //InicializarPinpad();

            _webApp = WebApp.Start<Startup>(url: baseUrl);

            Log.Information($"Servicio REST running en {baseUrl}");
        }

        public void Stop()
        {
            Log.Information("Deteniendo servicio REST...");
            _webApp?.Dispose();
        }

        private void InicializarPinpad()
        {
            try
            {
                var rg = RgService.Instance;
                var config = System.Configuration.ConfigurationManager.AppSettings;

                string url = config["UrlServicio"];
                string estacion = config["Estacion"];

                rg.Rg.EstablecerServicio(url);
                rg.Rg.EstablecerEstacion(estacion);
                rg.Rg.ConfigurarTerminal(estacion);
                rg.Rg.ConfigurarPinpad();

                Log.Information("Pinpad inicializado correctamente");
            }
            catch (Exception ex)
            {
                Log.Error(ex, "Error inicializando el pinpad");
            }
        }
    }
}