﻿using app_datafono_difare.Services;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Http;

namespace app_datafono_difare.Controllers
{
    public class PinpadController : ApiController   // <- heredar ApiController
    {
        [HttpPost]
        public async Task<IHttpActionResult> Autorizar([FromBody] decimal amount)
        {
            try
            {
                var service = new TransactionService(
                    RgService.Instance,
                    System.Configuration.ConfigurationManager.AppSettings["ArchivoBines"]
                );

                // SOLO se envía la venta — sin reconfigurar el pinpad
                var resp = await service.EnviarVenta(amount, 0);

                return Ok(resp);
            }
            catch (Exception ex)
            {
                return InternalServerError(ex);
            }
        }
    }
}
