﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare.Helpers
{
    public static class DateHelper
    {
        public static DateTime ParseDate(string fecha, string hora)
        {
            try
            {
                if (string.IsNullOrEmpty(fecha) || string.IsNullOrEmpty(hora))
                    return DateTime.Now;

                int year = int.Parse(fecha.Substring(0, 4));
                int month = int.Parse(fecha.Substring(4, 2));
                int day = int.Parse(fecha.Substring(6, 2));

                int hour = int.Parse(hora.Substring(0, 2));
                int min = int.Parse(hora.Substring(2, 2));
                int sec = int.Parse(hora.Substring(4, 2));

                return new DateTime(year, month, day, hour, min, sec);
            }
            catch
            {
                return DateTime.Now;
            }
        }
    }
}
