﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare.Helpers
{
    public static class ObtenerTipoTarjetaHelper
    {
        public static string ObtenerTipoTarjetaPorBin(string cardNumber,string ruta)
        {
            if (string.IsNullOrWhiteSpace(cardNumber) || cardNumber.Length < 6)
                return null;

            string bin = cardNumber.Substring(0, 6);

            if (!File.Exists(ruta))
                return null;

            var lineas = File.ReadAllLines(ruta);

            foreach (var linea in lineas)
            {
                if (linea.Length < 8)
                    continue;

                string binArchivo = linea.Substring(0, 6);

                if (binArchivo == bin)
                {
                    string tipo = linea.Substring(linea.Length - 2);
                    return tipo;
                }
            }

            return null;
        }
    }
}
