﻿using app_datafono_difare.Services;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using System;
using System.IO;
using System.Text;
using System.Threading.Tasks;
using Serilog;
using Serilog.Events;
using Topshelf;

namespace app_datafono_difare
{
    class Program
    {
        static void Main()
        {
            Log.Logger = new LoggerConfiguration()
                .MinimumLevel.Debug()
                .WriteTo.File("logs\\rest-pinpad.log", rollingInterval: RollingInterval.Day)
                .CreateLogger();

            HostFactory.Run(x =>
            {
                x.Service<PinpadService>(s =>
                {
                    s.ConstructUsing(() => new PinpadService());
                    s.WhenStarted(p => p.Start());
                    s.WhenStopped(p => p.Stop());
                });

                x.RunAsLocalSystem(); // Permisos de servicio

                x.SetServiceName("PinpadRestService");
                x.SetDisplayName("Pinpad REST Service");
                x.SetDescription("Servicio REST que expone las funciones del pinpad via OWIN Self-Host.");
            });
        }
    }

}