﻿using app_datafono_difare.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare.Services
{
    public class PinpadRestService
    {
        private readonly PinpadInitializer _init;
        private readonly TransactionService _txService;

        public PinpadRestService(PinpadInitializer init, TransactionService txService)
        {
            _init = init;
            _txService = txService;
        }

        public async Task<TransaccionResponse> AutorizarAsync(decimal amount, int cuotas)
        {
            // No toca inicializar aquí, ya debe estar inicializado antes
            return await _txService.EnviarVenta(amount, cuotas);
        }
    }
}
