using Serilog;
using System.IO;
using System.Text;

public class SerilogTextWriter : TextWriter
{
    private readonly ILogger _logger;

    public SerilogTextWriter(ILogger logger)
    {
        _logger = logger;
    }

    public override Encoding Encoding => Encoding.UTF8;

    public override void WriteLine(string value)
    {
        _logger.Information(value);
    }

    public override void Write(string value)
    {
        _logger.Information(value);
    }
}
