﻿using app_datafono_difare.Entities;
using ClsRgFunciones;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare.Services
{
    public class PinpadInitializer
    {
        private bool _initialized = false;
        private readonly RgFunciones _rg;

        public PinpadInitializer()
        {
            _rg = RgService.Instance.Rg;
        }

        public void Inicializar(string url, string estacion)
        {
            if (_initialized)
                return;

            _rg.EstablecerServicio(url);
            _rg.EstablecerEstacion(estacion);
            _rg.ConfigurarTerminal(estacion);
            _rg.ConfigurarPinpad();

            _initialized = true;
        }
    }
}
