﻿using app_datafono_difare.Services;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Serilog;
using System;
using System.IO;
using System.Text;
using System.Threading.Tasks;

namespace app_datafono_difare
{
    class Program
    {
        static async Task Main(string[] args)
        {
            //Validación de argumentos
            if (args.Length == 0)
            {
                Log.Error("ERROR: Sin argumentos");
                return;
            }
    

            var appConfig = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile("appsettings.json", optional: false)
                .Build();

            var serilogConfig = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile("appsettings.serilog.json", optional: true)
                .Build();

            Log.Logger = new LoggerConfiguration()
                .ReadFrom.Configuration(serilogConfig)
                .CreateLogger();

            //Redirige la salida a Serilog para logs
            Console.SetOut(new SerilogTextWriter(Log.Logger));
            Console.SetError(new SerilogTextWriter(Log.Logger));

            try
            {
                if (args[0].ToLower() == "autorizar")
                {
                    // Leer monto enviado desde el wrapper
                    if (args.Length < 2)
                    {
                        Log.Error("ERROR: No se recibio el monto");
                        Console.WriteLine("{\"Success\":false,\"Message\":\"Monto no recibido\"}");
                        return;
                    }

                    decimal amount = decimal.Parse(args[1]);
                    var rgService = RgService.Instance;

                    string rutaBines = appConfig["ArchivoBines"];
                    string url = appConfig["UrlServicio"];
                    string estacion = appConfig["Estacion"];

                    var ventaService = new TransactionService(rgService, rutaBines);

                    var resp = await ventaService.ProcesarVenta(url, estacion, amount, 0);

                    //  RESTAURAR OUTPUT A CONSOLA
                    Console.SetOut(new StreamWriter(Console.OpenStandardOutput(), Encoding.UTF8) { AutoFlush = true });
                    Console.SetError(new StreamWriter(Console.OpenStandardError(), Encoding.UTF8) { AutoFlush = true });

                    // mandamos JSON al wrapper
                    var json = JsonConvert.SerializeObject(resp);
                    Console.WriteLine(json);

                    return;
                }

                Log.Error("Comando no reconocido");
            }
            catch (Exception ex)
            {
                Log.Error(ex, "Error ejecutando la aplicación");
            }
            finally
            {
                Log.CloseAndFlush();
            }
        }
    }

}